/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResolverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResolverUtils.class);

    public static Object getJsonPathVal(Object obj, String path) {
        if (null == obj || StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        Configuration conf = Configuration.defaultConfiguration();
        try {
            Configuration readConf = conf.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext ctx = JsonPath.using((Configuration)readConf).parse(JSON.toJSONString((Object)obj));
            return ctx.read(path, new Predicate[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790json:{}\u4e2d\u7684\u8def\u5f84{}\u5f02\u5e38:{}", new Object[]{obj, path, e});
            return null;
        }
    }

    public static ReadContext getReadContext(Object obj, String path) {
        if (null == obj || StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        Configuration conf = Configuration.defaultConfiguration();
        try {
            Configuration readConf = conf.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext ctx = JsonPath.using((Configuration)readConf).parse(JSON.toJSONString((Object)obj));
            return ctx;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790json:{}\u4e2d\u7684\u8def\u5f84{}\u5f02\u5e38:{}", new Object[]{obj, path, e});
            return null;
        }
    }

    public static Object getJsonPathVal(ReadContext ctx, String path) {
        return ctx.read(path, new Predicate[0]);
    }

    public static String toJsonString(Object obj) {
        return JSON.toJSONString((Object)obj, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.QuoteFieldNames});
    }
}

