/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.util.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    public static String MODULE_EE = "executionEngine";
    private static String MODULE_EE_DESC = "EE - \u6267\u884c\u5f15\u64ce";
    public static String SUCCESS = "1";
    public static String WARING = "0";
    public static final String AGILEDATA_LOG_PREFIX = "agiledata_";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);

    public static void buildAgileLog(String step, String code, String input, String result, String suggestion) {
        JSONObject inputObject = new JSONObject();
        inputObject.put("input", (Object)input);
        input = inputObject.toJSONString();
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", (Object)result);
        result = resultObject.toJSONString();
        Log log = SUCCESS.equalsIgnoreCase(code) ? LogUtils.buildSuccessLog(MODULE_EE_DESC, step, input, result, suggestion) : (WARING.equalsIgnoreCase(code) ? LogUtils.buildWaringLog(MODULE_EE_DESC, step, input, result, suggestion) : LogUtils.buildErrorLog(MODULE_EE_DESC, step, code, input, result, suggestion));
        LOGGER.error(AGILEDATA_LOG_PREFIX + MODULE_EE + "_\u8bf7\u6c42\u8fc7\u7a0b\u4e3a_" + JsonUtil.getJsonString(log));
    }

    private static Log buildSuccessLog(String productComponent, String step, String input, String result, String suggestion) {
        return new Log("SUCCESS", productComponent, step, SUCCESS, input, result, suggestion);
    }

    private static Log buildWaringLog(String productComponent, String step, String input, String result, String suggestion) {
        return new Log("WARING", productComponent, step, WARING, input, result, suggestion);
    }

    private static Log buildErrorLog(String productComponent, String step, String code, String input, String result, String suggestion) {
        return new Log("ERROR", productComponent, step, code, input, result, suggestion);
    }

    public static void main(String[] args) {
        HashSet<String> actionParams = new HashSet<String>(2);
        HashSet sysParamKeys = new HashSet(2);
        actionParams.add("asssqq");
        actionParams.add("27902");
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("actionId", "fsa12d2344fs");
        reqMap.put("tenantId", "agiledemo");
        reqMap.put("actionParams", actionParams);
        reqMap.put("sysParams", sysParamKeys);
        LogUtils.buildAgileLog("getExecutionRule", SUCCESS, JsonUtil.getJsonString(reqMap), "", "");
        LogUtils.buildAgileLog("getExecutionRule", "502", JsonUtil.getJsonString(reqMap), "", "\u5730\u7aefMQ\u77ed\u7ebf\uff0c\u8bf7\u8054\u7cfb\u5ba2\u6237\u68c0\u67e5");
    }

    public static class Log {
        String logType;
        String productComponent;
        String step;
        String code;
        String input;
        String result;
        String suggestion;

        public Log(String logType, String productComponent, String step, String code, String input, String result, String suggestion) {
            this.logType = logType;
            this.productComponent = productComponent;
            this.step = step;
            this.code = code;
            this.input = input;
            this.result = result;
            this.suggestion = suggestion;
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getLogType() {
            return this.logType;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        public String getProductComponent() {
            return this.productComponent;
        }

        public void setProductComponent(String productComponent) {
            this.productComponent = productComponent;
        }

        public String getStep() {
            return this.step;
        }

        public void setStep(String step) {
            this.step = step;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }
    }
}

