package com.digiwin.athena.executionengine.service.facade.event;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import org.springframework.context.ApplicationEvent;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/5/20
 */
public class ActionEvent extends ApplicationEvent {

    private String actionId;
    private volatile ExecuteContext context;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public ActionEvent(Object source, String actionId, ExecuteContext context) {
        super(source);
        this.actionId = actionId;
        this.context = context;
    }

    public ExecuteContext getContext() {
        return context;
    }

    public String getActionId() {
        return actionId;
    }
}
