package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.dto.schema.LeftDto;
import com.digiwin.athena.executionengine.dto.schema.RightDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;


/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/13
 */

@Service
public class DataCenterHavingConvertor extends AbstractSchemaConvertor {

    private static final String SUPPORT_FUN = "AVG,SUM,COUNT,MAX,MIN";

    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        if (schemaTransDto.getDynamicSchema() == null) {
            return;
        }

        JSONObject having = (JSONObject) schemaTransDto.getDynamicSchema();

        JSONObject computeObj = schemaTransDto.getComputeObj();
        if (MapUtils.isEmpty(having) || MapUtils.isEmpty(computeObj)) {
            return;
        }

        JSONObject mappingFields = (JSONObject) schemaTransDto.getReqData();


        JSONArray children = having.getJSONArray("children");
        String logic = having.getString("logic");

        children.stream().forEach(child -> doConvert(schemaTransDto.getQuerySchema(), computeObj, (JSONObject) child, logic, mappingFields));
    }

    private void doConvert(JSONObject querySchema, JSONObject computeObj, JSONObject child, String logic, JSONObject mappingFields) {

        LeftDto leftDto = getLeftField(child, computeObj);
        String operate = child.getString("operator");
        RightDto rightDto = getRightField(child, computeObj);

        if (leftDto == null || rightDto == null) {
            return;
        }

        // 值类型，0-固定值，1-度量
        if (rightDto.getHavingRightType() == 1) {
            return;
        }


        JSONObject modelObj = new JSONObject();
        JSONArray children = new JSONArray();
        modelObj.put("logic", logic);
        modelObj.put("children", children);

        JSONObject childObj = new JSONObject();
        childObj.put("field", mappingFields.getString(leftDto.getLeftField()));

        JSONObject aggregator = new JSONObject();
        aggregator.put("function", leftDto.getFunction());
        aggregator.put("distinct", false);
        childObj.put("aggregator", aggregator);

        childObj.put("operator", CommonConstant.DATA_CENTER_FILTER_TYPE_COMPARISON_MAP.get(operate));
        childObj.put("dataType", rightDto.getHavingRightType());
        childObj.put("data", rightDto.getRightValue());
        if (rightDto.getHavingRightType() == 0) {
            childObj.put("dataAggregator", null);
        } else {
            JSONObject dataAggregator = new JSONObject();
            dataAggregator.put("function", rightDto.getFunction());
            dataAggregator.put("distinct", false);
        }
        children.add(childObj);

        querySchema.getJSONArray("havingFilters").add(modelObj);
    }

    private RightDto getRightField(JSONObject child, JSONObject computeObj) {
        JSONArray rights = child.getJSONArray("right");
        if (CollectionUtils.isEmpty(rights)) {
            return null;
        }
        JSONObject rightObj = rights.getJSONObject(0);

        JSONObject dataObject = rightObj.getJSONObject("dataObject");
        if (MapUtils.isEmpty(dataObject)) {
            return null;
        }

        String contentType = dataObject.getString("contentType");
        String rightValue;
        String calFunction = null;
        int rightDataType;

        if ("const".equals(contentType)) {
            rightDataType = 0;
            rightValue = dataObject.getString("content");
        } else if ("calculate".equals(contentType)) {
            rightDataType = 1;

            JSONArray computeList = computeObj.getJSONArray(dataObject.getString("content"));
            if (CollectionUtils.isEmpty(computeList)) {
                return null;
            }
            if (computeList.size() > 1) {
                return null;
            }

            JSONObject jsonObject = computeList.getJSONObject(0);

            rightValue = jsonObject.getJSONArray("params").getJSONObject(0).getString("content");
            calFunction = jsonObject.getString("calFunction");

        } else {
            return null;
        }
        return new RightDto(rightValue, calFunction, rightDataType);
    }

    private LeftDto getLeftField(JSONObject child, JSONObject computeObj) {
        JSONObject left = child.getJSONObject("left");
        String contentType = left.getString("contentType");
        String leftField;
        String calFunction = null;
        if ("field".equals(contentType)) {
            leftField = left.getString("content");
        } else if ("calculate".equals(contentType)) {
            JSONArray computeList = computeObj.getJSONArray(left.getString("content"));
            if (CollectionUtils.isEmpty(computeList)) {
                return null;
            }
            if (computeList.size() > 1) {
                return null;
            }

            JSONObject jsonObject = computeList.getJSONObject(0);

            leftField = jsonObject.getJSONArray("params").getJSONObject(0).getString("content");
            calFunction = jsonObject.getString("calFunction");
        } else {
            return null;
        }

        if (StringUtils.isNotBlank(calFunction) && !SUPPORT_FUN.contains(calFunction.toUpperCase())) {
            return null;
        }
        String function = calFunction.toLowerCase();

        return new LeftDto(leftField, "", function);
    }
}