package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.Step;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fenglei
 * @date: 2024-2-2
 */
@Component("chooseColumn")
public class ChooseColumnStep extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChooseColumnStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        //输入数据
        Object inputData = getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.error("addColumnstep组件只能处理表状数据，非表状数据需要先执行展平节点！Trans执行 {} 失败，数据结构错误！", step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }

        List<Map<String, Object>> dataList = (List<Map<String, Object>>) (inputData);
        // 数据源为空直接返回
        if (CollectionUtils.isEmpty(dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }

        // 获取剔除或者保留的字段
        List<String> fieldList = step.getStepElement().getFields();
        if (CollectionUtils.isEmpty(fieldList)) {
            LOGGER.warn("chooseColumn定义没有field字段");
            dealResult.setSuccess(dataList);
            return dealResult;
        }

        if (step.getStepElement().getType().equals("remove")) {
            dataList.forEach(item -> item.remove(fieldList));
        } else if (step.getStepElement().getType().equals("retain")) {
            List<String> removeColumn = getRemoveColumnMap(fieldList, dataList);
            dataList.forEach(item -> removeColumn.forEach(k -> item.remove(k)));
        } else {
            LOGGER.error("chooseColumn选择类型没有定义：{}", step.getStepElement().getType());
            dealResult.setDataNullFail();
            return dealResult;
        }
        dealResult.setSuccess(dataList);
        return dealResult;
    }

    private List<String> getRemoveColumnMap(List<String> fieldList, List<Map<String, Object>> dataList) {
        Map<String, Object> record = dataList.get(0);
        List<String> removeKey = new ArrayList<>();

        for (String key : record.keySet()) {
            if (!fieldList.contains(key)) {
                removeKey.add(key);
            }
        }

        return removeKey;
    }

    /**
     * "step":[
     *   {
     *     "name":"chooseColumnStep",
     *     "technique": "chooseColumn",
     *     "type":"retain",      ///保留：retain（在数据里保留fields中描述的字段）， 去除：remove（将fields中描述的字段从数据中剔除）
     *     "fields":["key1","key2","key3"...]
     *   }
     * ]
     */
}
