/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.enumtype.ValueTypeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.service.facade.analyzer.AbstractAnalyzerBase;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.AnalysisUtils;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineMetadataAnalyzer")
public class MetadataAnalyzer
extends AbstractAnalyzerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataAnalyzer.class);
    @Autowired
    private ITransSchemaCreator transSchemaCreator;

    @Override
    protected void analysisHandler(JSONObject executionRule) {
        if (MapUtils.isEmpty((Map)executionRule)) {
            return;
        }
        JSONArray metadatas = executionRule.getJSONArray("actionMetadatas");
        JSONObject standardParameterMapping = executionRule.getJSONObject("standardParameterMapping");
        if (CollectionUtils.isEmpty((Collection)metadatas)) {
            LOGGER.warn("\u6ca1\u6709\u9700\u8981\u5206\u6790\u7684metadatas");
        }
        this.analysisActionMetaParam(metadatas, standardParameterMapping);
    }

    private void analysisActionMetaParam(JSONArray metadatas, JSONObject standardParameterMapping) {
        for (int i = 0; i < metadatas.size(); ++i) {
            JSONObject aggregation;
            JSONObject querySchema;
            JSONObject metaDataObj = metadatas.getJSONObject(i);
            String actionType = metaDataObj.getString("type");
            ActionTypeEnum typeEnum = ActionTypeEnum.getEnumByType(actionType);
            String actionId = metaDataObj.getString("actionId");
            ActionParam actionParam = new ActionParam(actionId, typeEnum.getClassName(), actionType, metaDataObj);
            actionParam.setStandardParameterMapping(standardParameterMapping);
            if (metaDataObj.containsKey((Object)"type") && "MICRO_TRANS".equals(metaDataObj.get((Object)"type").toString())) {
                JSONArray microTransList = metaDataObj.getJSONArray("microTrans");
                JSONObject microTransSchema = this.createTransSchema(microTransList);
                actionParam.setMicroTrans(microTransSchema);
            }
            if (metaDataObj.containsKey((Object)"apiMeta")) {
                JSONArray apiMeta = metaDataObj.getJSONArray("apiMeta");
                List<ParamElement> paramElements = this.analyseApiMeta(actionId, apiMeta);
                actionParam.setApiMeta(paramElements);
            }
            if ((querySchema = metaDataObj.getJSONObject("querySchema")) != null) {
                actionParam.setQuerySchema(querySchema);
            }
            if ((aggregation = metaDataObj.getJSONObject("aggregation")) != null) {
                actionParam.setAggregation(aggregation);
            }
            MetadataAnalyzer.getLocalContext().addActionParam(actionParam);
            this.analysisReqMetaDatas(metaDataObj, actionParam);
            this.analysisRespMetaDatas(metaDataObj);
        }
    }

    private List<ParamElement> analyseApiMeta(String actionId, JSONArray apiMeta) {
        ArrayList<ParamElement> paramElements = new ArrayList<ParamElement>();
        for (int i = 0; i < apiMeta.size(); ++i) {
            JSONObject param = apiMeta.getJSONObject(i);
            this.analysisParameter(param, actionId, null, null);
            String path = AnalysisUtils.concatByDot(actionId, "$", param.getString("data_name"));
            ParamElement element = MetadataAnalyzer.getLocalContext().getParamElement(path);
            paramElements.add(element);
        }
        return paramElements;
    }

    private void analysisReqMetaDatas(JSONObject metadata, ActionParam actionParam) {
        String actionId = metadata.getString("actionId");
        JSONObject requestObj = metadata.getJSONObject("request");
        JSONArray parameters = requestObj.getJSONArray("parameters");
        if (CollectionUtils.isEmpty((Collection)parameters)) {
            return;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            JSONObject param = parameters.getJSONObject(i);
            this.analysisParameter(param, actionId, null, null);
            String path = AnalysisUtils.concatByDot(actionId, "$", param.getString("data_name"));
            ParamElement element = MetadataAnalyzer.getLocalContext().getParamElement(path);
            if (null == element) continue;
            actionParam.getRequestParams().add(element);
        }
    }

    private void analysisRespMetaDatas(JSONObject metadata) {
        String actionId = metadata.getString("actionId");
        JSONObject respObject = metadata.getJSONObject("response");
        if (MapUtils.isEmpty((Map)respObject)) {
            return;
        }
        JSONObject parameter = respObject.getJSONObject("data");
        if (MapUtils.isEmpty((Map)parameter)) {
            return;
        }
        this.analysisParameter(parameter, actionId, null, null);
    }

    private void analysisParameter(JSONObject param, String actionId, ParamElement parentElement, List<ParamElement> children) {
        ParamElement paramElement = new ParamElement();
        paramElement.setActionId(actionId);
        paramElement.setParentElement(parentElement);
        paramElement.setParamName(param.getString("data_name"));
        paramElement.setValueType(ValueTypeEnum.getEnumByType(param.getString("data_type")));
        paramElement.setArray(Optional.ofNullable(param.getBoolean("is_array")).orElse(false));
        paramElement.setIsDataKey(Optional.ofNullable(param.getBoolean("is_datakey")).orElse(false));
        paramElement.setIsRequired(Optional.ofNullable(param.getBoolean("required")).orElse(false));
        if (null != children) {
            children.add(paramElement);
        }
        String elementPath = Optional.ofNullable(parentElement).filter(parent -> StringUtils.isNotBlank((CharSequence)parent.getParamPath())).map(parent -> AnalysisUtils.concatByDot(parent.getParamPath(), paramElement.getParamName())).orElse(AnalysisUtils.concatByDot(actionId, "$", paramElement.getParamName()));
        paramElement.setParamPath(elementPath);
        String parentJsonPath = "$";
        if (null != parentElement) {
            parentJsonPath = parentElement.getElementJsonPath();
            if (parentElement.getArray().booleanValue()) {
                parentJsonPath = StringUtils.join((Object[])new String[]{parentJsonPath, "[*]"});
            }
        }
        paramElement.setElementJsonPath(parentJsonPath);
        if (StringUtils.isNotBlank((CharSequence)paramElement.getParamName())) {
            paramElement.setElementJsonPath(AnalysisUtils.concatByDot(parentJsonPath, paramElement.getParamName()));
        }
        MetadataAnalyzer.getLocalContext().addParamElement(paramElement.getParamPath(), paramElement);
        JSONArray fields = param.getJSONArray("field");
        if (!ValueTypeEnum.OBJECT.equals((Object)paramElement.getValueType()) || CollectionUtils.isEmpty((Collection)fields)) {
            return;
        }
        ArrayList childList = Lists.newArrayList();
        paramElement.setChildElements(childList);
        for (int i = 0; i < fields.size(); ++i) {
            JSONObject fieldObj = fields.getJSONObject(i);
            this.analysisParameter(fieldObj, actionId, paramElement, childList);
        }
    }

    private JSONObject createTransSchema(JSONArray microTrans) {
        JSONObject micTrans = microTrans.getJSONObject(0);
        this.buildDistinctParam(micTrans);
        String template = this.transSchemaCreator.createTransSchemaByTemplate(micTrans);
        try {
            return JSONObject.parseObject((String)ReplaceUtils.replace(micTrans, template));
        }
        catch (Exception e) {
            LOGGER.error("micTrans\u5b9a\u4e49\u8f6c\u6362\u5931\u8d25,micTrans:{},template:{}", new Object[]{micTrans, template, e});
            throw e;
        }
    }

    private void buildDistinctParam(JSONObject micTrans) {
        String technique = micTrans.getString("technique");
        if ("count,sum,average,min,max,group,variance,stddev,accSum".indexOf(technique) == -1) {
            return;
        }
        JSONArray groupFields = micTrans.getJSONArray("groupFields");
        JSONArray statistics = micTrans.getJSONArray("statistics");
        statistics.forEach(stat -> groupFields.add((Object)((JSONObject)stat).getString("newField")));
        micTrans.put("distinctFields", (Object)groupFields);
    }
}

