/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.mapping.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DataNode {
    private String nodeId = UUID.randomUUID().toString();
    private String nodeName;
    private String parentNodeId;
    private int totalCnt;
    private String lastCollectionNode;
    private Map<String, Integer> zone;
    private int zonePos;
    private int globalPos;
    private boolean isObject;
    private List<String> children;
    private boolean isArray;
    private boolean isArrayAsObject;
    private String pathTemplate;
    private String paramPath;
    private String maxSizeChildNodeId;
    private List<String> jsonRoute;

    public DataNode() {
        this.nodeName = "";
        this.parentNodeId = null;
        this.totalCnt = 0;
        this.lastCollectionNode = "";
        this.zone = new HashMap<String, Integer>();
        this.zonePos = -1;
        this.globalPos = -1;
        this.children = null;
        this.isObject = false;
        this.isArray = false;
        this.isArrayAsObject = false;
        this.pathTemplate = "";
        this.paramPath = "";
        this.maxSizeChildNodeId = null;
        this.jsonRoute = null;
    }

    public DataNode(String nodeName, String parentNodeId, String lastCollectionNode, int totalCnt, boolean isObject, boolean isArray, boolean isArrayAsObject, String pathTemplate, String paramPath, List<String> lastRoute) {
        this.zone = new HashMap<String, Integer>();
        this.children = new ArrayList<String>();
        this.nodeName = nodeName;
        this.parentNodeId = parentNodeId;
        this.totalCnt = 0;
        this.lastCollectionNode = lastCollectionNode;
        this.zonePos = 0;
        this.globalPos = -1;
        if (isArray) {
            this.globalPos = 0;
        }
        this.isObject = isObject;
        this.isArray = isArray;
        this.isArrayAsObject = isArrayAsObject;
        this.pathTemplate = pathTemplate;
        this.paramPath = paramPath;
        this.maxSizeChildNodeId = null;
        this.jsonRoute = new ArrayList<String>();
        this.addAllJsonRoute(lastRoute);
    }

    public void setEmptyMap() {
        this.totalCnt = 0;
        this.zonePos = 0;
        this.globalPos = -1;
        if (this.isArray) {
            this.globalPos = 0;
        }
        this.maxSizeChildNodeId = null;
    }

    protected void addChildren(String childId) {
        this.children.add(childId);
    }

    protected void addAllJsonRoute(List<String> lastRoute) {
        if (lastRoute != null && !lastRoute.isEmpty()) {
            this.jsonRoute.addAll(lastRoute);
        }
    }

    protected String getNodeId() {
        return this.nodeId;
    }

    protected void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    protected void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    protected String getParentNodeId() {
        return this.parentNodeId;
    }

    protected void setParentNodeId(String parentNodeId) {
        this.parentNodeId = parentNodeId;
    }

    protected int getTotalCnt() {
        return this.totalCnt;
    }

    protected void setTotalCnt(int totalCnt) {
        this.totalCnt = totalCnt;
    }

    protected String getLastCollectionNode() {
        return this.lastCollectionNode;
    }

    protected void setLastCollectionNode(String lastCollectionNode) {
        this.lastCollectionNode = lastCollectionNode;
    }

    protected Map<String, Integer> getZone() {
        return this.zone;
    }

    protected void setZone(Map<String, Integer> zone) {
        this.zone = zone;
    }

    protected void addZone(String key, Integer value) {
        this.zone.put(key, value);
    }

    protected int getZonePos() {
        return this.zonePos;
    }

    protected void setZonePos(int zonePos) {
        this.zonePos = zonePos;
    }

    protected int getGlobalPos() {
        return this.globalPos;
    }

    protected void setGlobalPos(int globalPos) {
        this.globalPos = globalPos;
    }

    protected List<String> getChildren() {
        return this.children;
    }

    protected void setChildren(List<String> children) {
        this.children = children;
    }

    protected boolean isObject() {
        return this.isObject;
    }

    protected void setObject(boolean isObject) {
        this.isObject = isObject;
    }

    protected boolean isArray() {
        return this.isArray;
    }

    protected void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    protected boolean isArrayAsObject() {
        return this.isArrayAsObject;
    }

    protected void setArrayAsObject(boolean isArrayAsObject) {
        this.isArrayAsObject = isArrayAsObject;
    }

    protected String getPathTemplate() {
        return this.pathTemplate;
    }

    protected void setPathTemplate(String pathTemplate) {
        this.pathTemplate = pathTemplate;
    }

    protected String getParamPath() {
        return this.paramPath;
    }

    protected void setParamPath(String paramPath) {
        this.paramPath = paramPath;
    }

    protected String getMaxSizeChildNodeId() {
        return this.maxSizeChildNodeId;
    }

    protected void setMaxSizeChildNodeId(String maxSizeChildNodeId) {
        this.maxSizeChildNodeId = maxSizeChildNodeId;
    }

    protected List<String> getJsonRoute() {
        return this.jsonRoute;
    }

    protected void setJsonRoute(List<String> jsonRoute) {
        this.jsonRoute = jsonRoute;
    }

    protected void addTotalCnt(int count) {
        this.totalCnt += count;
    }
}

