/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.reporter;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.reporter.ErrorLogReportDto;
import com.digiwin.athena.executionengine.model.reporter.ReporterDto;
import com.digiwin.athena.executionengine.service.facade.reporter.IReporter;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineErrorLogReporter")
public class ErrorLogReporter
implements IReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorLogReporter.class);

    @Override
    public void report(ReporterDto reporterDto) {
        ErrorLogReportDto errorLogReportDto = (ErrorLogReportDto)reporterDto;
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put("token", errorLogReportDto.getToken());
            header.put("routerKey", errorLogReportDto.getRouterKey());
            HttpClientUtils.doPost(ModuleProperty.AGILE_DATA_ECHO_URL, header, JSON.toJSONString((Object)errorLogReportDto));
        }
        catch (Exception e) {
            LOGGER.error("errorlog report error", (Throwable)e);
        }
    }
}

