/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.dto.schema.LeftDto;
import com.digiwin.athena.executionengine.dto.schema.RightDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HavingConvertor
extends AbstractSchemaConvertor {
    private static final String SUPPORT_FUN = "AVG,SUM,COUNT,MAX,MIN";

    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        if (schemaTransDto.getDynamicSchema() == null) {
            return;
        }
        JSONObject having = null;
        if (schemaTransDto.getDynamicSchema() instanceof JSONObject) {
            having = (JSONObject)schemaTransDto.getDynamicSchema();
        } else if (schemaTransDto.getDynamicSchema() instanceof Map) {
            having = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getDynamicSchema()));
        }
        JSONObject computeObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getComputeObj()));
        if (MapUtils.isEmpty((Map)having) || MapUtils.isEmpty((Map)computeObj)) {
            return;
        }
        JSONArray children = having.getJSONArray("children");
        String logic = having.getString("logic");
        children.stream().forEach(child -> this.doConvert(schemaTransDto.getQuerySchema(), computeObj, (JSONObject)child, logic));
    }

    private void doConvert(JSONObject querySchema, JSONObject computeObj, JSONObject child, String logic) {
        LeftDto leftDto = this.getLeftField(child, computeObj);
        String operate = child.getString("operator");
        RightDto rightDto = this.getRightField(child, computeObj);
        if (leftDto == null || rightDto == null) {
            return;
        }
        Map<String, String> mapping = this.getReversalShowFieldMapping(querySchema);
        if (!mapping.containsKey(leftDto.getLeftField())) {
            return;
        }
        if (rightDto.getHavingRightType() == 1 && !mapping.containsKey(rightDto.getRightValue())) {
            return;
        }
        JSONObject modelObj = new JSONObject();
        JSONArray children = new JSONArray();
        modelObj.put("logic", (Object)logic);
        modelObj.put("children", (Object)children);
        JSONObject childObj = new JSONObject();
        childObj.put("field", (Object)mapping.get(leftDto.getLeftField()));
        JSONObject aggregator = new JSONObject();
        aggregator.put("function", (Object)leftDto.getFunction());
        aggregator.put("distinct", (Object)false);
        childObj.put("aggregator", (Object)aggregator);
        childObj.put("operator", (Object)CommonConstant.FILTER_TYPE_COMPARISON_MAP.get(operate));
        childObj.put("dataType", (Object)rightDto.getHavingRightType());
        childObj.put("data", (Object)rightDto.getRightValue());
        if (rightDto.getHavingRightType() == 0) {
            childObj.put("dataAggregator", null);
        } else {
            JSONObject dataAggregator = new JSONObject();
            dataAggregator.put("function", (Object)rightDto.getFunction());
            dataAggregator.put("distinct", (Object)false);
        }
        children.add((Object)childObj);
        querySchema.getJSONArray("havingFilters").add((Object)modelObj);
    }

    private RightDto getRightField(JSONObject child, JSONObject computeObj) {
        String rightValue;
        int rightDataType;
        JSONArray rights = child.getJSONArray("right");
        if (CollectionUtils.isEmpty((Collection)rights)) {
            return null;
        }
        JSONObject rightObj = rights.getJSONObject(0);
        JSONObject dataObject = rightObj.getJSONObject("dataObject");
        if (MapUtils.isEmpty((Map)dataObject)) {
            return null;
        }
        String contentType = dataObject.getString("contentType");
        String calFunction = null;
        if ("const".equals(contentType)) {
            rightDataType = 0;
            rightValue = dataObject.getString("content");
        } else if ("calculate".equals(contentType)) {
            rightDataType = 1;
            JSONArray computeList = computeObj.getJSONArray(dataObject.getString("content"));
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return null;
            }
            if (computeList.size() > 1) {
                return null;
            }
            JSONObject jsonObject = computeList.getJSONObject(0);
            rightValue = jsonObject.getJSONArray("params").getJSONObject(0).getString("content");
            calFunction = jsonObject.getString("calFunction");
        } else {
            return null;
        }
        return new RightDto(rightValue, calFunction, rightDataType);
    }

    private LeftDto getLeftField(JSONObject child, JSONObject computeObj) {
        String leftField;
        JSONObject left = child.getJSONObject("left");
        String contentType = left.getString("contentType");
        String calFunction = null;
        if ("field".equals(contentType)) {
            leftField = left.getString("content");
        } else if ("calculate".equals(contentType)) {
            JSONArray computeList = computeObj.getJSONArray(left.getString("content"));
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return null;
            }
            if (computeList.size() > 1) {
                return null;
            }
            JSONObject jsonObject = computeList.getJSONObject(0);
            leftField = jsonObject.getJSONArray("params").getJSONObject(0).getString("content");
            calFunction = jsonObject.getString("calFunction");
        } else {
            return null;
        }
        if (StringUtils.isNotBlank(calFunction) && !SUPPORT_FUN.contains(calFunction.toUpperCase())) {
            return null;
        }
        String function = calFunction.toLowerCase();
        return new LeftDto(leftField, "", function);
    }
}

