/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.srp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.CustomException;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.model.trans.MicroTrans;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import com.digiwin.athena.executionengine.util.PlatformServiceUtils;
import com.digiwin.athena.executionengine.util.TranCovertUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransSrp
implements ITransSrp {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransSrp.class);

    @Override
    public ServiceResult runTrans(String tenantId, String ruleId, Map<String, Object> reqMap, Map<String, Object> eocMap) {
        ServiceResult serviceResult = new ServiceResult(false);
        LOGGER.info("\u5f00\u59cb\u6267\u884cTrans\u5904\u7406:{}", (Object)JSON.toJSONString(reqMap));
        if (reqMap == null) {
            LOGGER.warn("\u6267\u884cTrans\u5904\u7406\u5165\u53c2\u4e3a\u7a7a");
            return serviceResult;
        }
        JSONObject ruleJsonObj = PlatformServiceUtils.getRuleInfo(ruleId);
        if (ruleJsonObj == null) {
            LOGGER.error("\u901a\u8fc7ruleId:{}\u672a\u83b7\u53d6\u5230TransRule", (Object)ruleId);
            throw ExceptionUtils.buildCustomException(ErrorCodeEnum.TRANS_RULE_NOT_FOUND, ruleId);
        }
        LOGGER.info("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7684rule\u89c4\u5219:{}", (Object)ruleJsonObj);
        String version = ruleJsonObj.getString("version");
        if (version == null) {
            LOGGER.error("\u8bf7\u5207\u6362\u5230Trans V2\u7248\u672c\uff0cV1\u7248\u672c\u4e0d\u518d\u7ef4\u62a4");
            throw new CustomException(ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getCode(), ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getMessage());
        }
        TransDataManger transDataManger = new TransDataManger(ruleJsonObj, reqMap, tenantId, eocMap);
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        serviceResult.setData(transEngine.runEngine(transDataManger));
        serviceResult.setSuccess(true);
        LOGGER.info("Trans\u6267\u884c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)serviceResult.getData()));
        return serviceResult;
    }

    @Override
    public ServiceResult runTransByTransAction(ExecuteContext context, String ruleId, Map<String, Object> reqMap) {
        ServiceResult serviceResult = new ServiceResult(false);
        LOGGER.info("\u5f00\u59cb\u6267\u884cTrans\u5904\u7406:{}", (Object)JSON.toJSONString(reqMap));
        if (reqMap == null) {
            LOGGER.warn("\u6267\u884cTrans\u5904\u7406\u5165\u53c2\u4e3a\u7a7a");
            return serviceResult;
        }
        JSONObject ruleJsonObj = PlatformServiceUtils.getRuleInfoParaller(ruleId, context.getToken(), context.getTenantId());
        if (ruleJsonObj == null) {
            LOGGER.error("\u901a\u8fc7ruleId:{}\u672a\u83b7\u53d6\u5230TransRule", (Object)ruleId);
            throw ExceptionUtils.buildCustomException(ErrorCodeEnum.TRANS_RULE_NOT_FOUND, ruleId);
        }
        LOGGER.info("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7684rule\u89c4\u5219:{}", (Object)ruleJsonObj);
        String version = ruleJsonObj.getString("version");
        if (version == null) {
            LOGGER.error("\u8bf7\u5207\u6362\u5230Trans V2\u7248\u672c\uff0cV1\u7248\u672c\u4e0d\u518d\u7ef4\u62a4");
            throw new CustomException(ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getCode(), ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getMessage());
        }
        TransDataManger transDataManger = new TransDataManger(ruleJsonObj, reqMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        serviceResult.setData(transEngine.runEngine(transDataManger));
        serviceResult.setSuccess(true);
        LOGGER.info("Trans\u6267\u884c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)serviceResult.getData()));
        return serviceResult;
    }

    @Override
    public ServiceResult runTrans(String tenantId, List<Map<String, Object>> recasts, Object data) {
        ServiceResult serviceResult = new ServiceResult(false);
        try {
            MicroTrans microTrans = TranCovertUtils.buildTransByRecast(recasts);
            TransDataManger transDataManger = new TransDataManger(JsonUtil.getObject(JsonUtil.getJsonString(microTrans)), data, tenantId);
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
            serviceResult.setData(transEngine.runEngine(transDataManger));
            serviceResult.setSuccess(true);
            LOGGER.info("Trans\u6267\u884c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)serviceResult.getData()));
        }
        catch (Exception e) {
            LOGGER.error("\u539f\u6570\u636e\uff1a" + JsonUtil.getJsonString(data) + "recasts\uff1a" + JsonUtil.getJsonString(recasts));
            e.printStackTrace();
        }
        return serviceResult;
    }
}

