/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.serviceclient.ServiceClient;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.espsdk.EspSdkReqParam;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.SecurityUtils;
import com.digiwin.athena.smartdata.sdk.InvokerProxy;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformServiceUtils.class);

    private PlatformServiceUtils() {
    }

    public static ServiceClient getServiceClient() {
        return new ServiceClient();
    }

    public static String invokeOtherService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        ServiceClient serviceClient = PlatformServiceUtils.getServiceClient();
        return serviceClient.invokeOtherDapService(apName, moduleName, serviceName, methodName, parameter);
    }

    public static String getTenantSecretKey(String tenantId) throws Exception {
        Map<String, Object> licenseKeyParam = PlatformServiceUtils.licenseKeyParam(tenantId);
        LOGGER.info("\u6c42\u53d6licenseKey\u5165\u53c2\uff1alicenseKeyParam:{}", licenseKeyParam);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_APP_LICENSEKEY + tenantId, header, null);
        if (StringUtils.isBlank((CharSequence)httpResp)) {
            return null;
        }
        JSONObject httpRespOjb = JSONObject.parseObject((String)httpResp);
        if (200 != httpRespOjb.getIntValue("status")) {
            return null;
        }
        String data = httpRespOjb.getString("response");
        return SecurityUtils.decodeAes(data);
    }

    public static JSONObject getRuleInfo(String ruleId) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", DWServiceContext.getContext().getToken());
        header.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        header.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_ACTION_RULE + ruleId, header, null);
        if (StringUtils.isBlank((CharSequence)httpResp)) {
            return null;
        }
        return Optional.of(httpResp).map(resp -> JSONObject.parseObject((String)resp)).filter(obj -> 200 == obj.getIntValue("status")).map(obj -> obj.getJSONObject("response")).orElse(null);
    }

    public static JSONObject getRuleInfoParaller(String ruleId, String token, String routerKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        header.put("routerKey", routerKey);
        header.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_ACTION_RULE + ruleId, header, null);
        if (StringUtils.isBlank((CharSequence)httpResp)) {
            return null;
        }
        return Optional.of(httpResp).map(resp -> JSONObject.parseObject((String)resp)).filter(obj -> 200 == obj.getIntValue("status")).map(obj -> obj.getJSONObject("response")).orElse(null);
    }

    public static String getTenantTokenAndAddProfile(String tenantId) throws Exception {
        String secretKey = PlatformServiceUtils.getTenantSecretKey(tenantId);
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            return "";
        }
        Map<String, Object> iamResult = PlatformServiceUtils.getLoginResponse(secretKey);
        if (MapUtils.isEmpty(iamResult)) {
            return "";
        }
        HashMap<String, Object> profile = new HashMap<String, Object>();
        profile.put("tenantId", MapUtils.getString(iamResult, (Object)"tenantId"));
        profile.put("tenantName", MapUtils.getString(iamResult, (Object)"tenantName"));
        profile.put("tenantSid", MapUtils.getLongValue(iamResult, (Object)"tenantSid"));
        profile.put("userId", MapUtils.getString(iamResult, (Object)"userId"));
        profile.put("userName", MapUtils.getString(iamResult, (Object)"userName"));
        DWServiceContext.getContext().setToken(MapUtils.getString(iamResult, (Object)"token"));
        DWServiceContext.getContext().setProfile(profile);
        return MapUtils.getString(iamResult, (Object)"token");
    }

    public static Map<String, Object> getLoginResponse(String secretKey) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("secretKey", secretKey);
        paramMap.put("identityType", "secretKey");
        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL(ModuleProperty.IAM_USERLOGINURL);
        iamModel.setParams(paramMap);
        iamModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
        if (200 == responseModel.getHttpStatusCode()) {
            return JSONObject.parseObject((String)responseModel.getResponseBody());
        }
        return null;
    }

    public static ResponseModel callEsp(RequestModel requestModel) throws Exception {
        return InvokerProxy.invokeRestSync((RequestModel)requestModel);
    }

    @Deprecated
    public static String callEsp(EspSdkReqParam reqParam) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", reqParam.getToken());
        header.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        return InvokerProxy.invokeRestSync((String)reqParam.getHostProd(), (String)reqParam.getHostVer(), (String)reqParam.getHostId(), (String)reqParam.getHostAcct(), (String)reqParam.getTenantId(), (String)reqParam.getServiceProd(), (String)reqParam.getServiceProdUid(), (String)reqParam.getServiceName(), reqParam.getDatakey(), header, (String)reqParam.getBodyJsonString(), reqParam.getEocMap());
    }

    public static Map<String, Object> licenseKeyParam(String tenantId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        String key = DigestUtils.md5Hex((String)sb.append(tenantId).append(ModuleProperty.THEMEMAP_LICENSEKEY_REQUEST_FROM).append(timestamp).append(ModuleProperty.THEMEMAP_LICENSEKEY_MD5_KEY).toString());
        param.put("tenantId", tenantId);
        param.put("requestFrom", ModuleProperty.THEMEMAP_LICENSEKEY_REQUEST_FROM);
        param.put("timestamp", timestamp);
        param.put("key", key);
        return param;
    }
}

