/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.trans.GroupElement;
import com.digiwin.athena.executionengine.model.trans.MicroTrans;
import com.digiwin.athena.executionengine.model.trans.Statistic;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TranCovertUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranCovertUtils.class);

    public static MicroTrans buildTransByRecast(List<Map<String, Object>> recasts) {
        MicroTrans microTrans = new MicroTrans();
        ArrayList<StepElement> stepElements = new ArrayList<StepElement>();
        int stepIndex = 0;
        stepElements.add(StepElement.buildSpread("spread_" + ++stepIndex));
        stepElements.add(StepElement.buildTruncateKey("truncateKey_" + stepIndex));
        ArrayList<Object> newRecasts = new ArrayList();
        if (!CollectionUtils.isEmpty(recasts)) {
            TreeMap<Integer, Map<String, Object>> orderedRecastMap = new TreeMap<Integer, Map<String, Object>>();
            for (Map<String, Object> recast : recasts) {
                String type = (String)recast.get("name");
                int index = "filter,measure,distinct,calculate,having,sort,limit,seqNo,choose".indexOf(type);
                if (index == -1) continue;
                orderedRecastMap.put(index, recast);
            }
            newRecasts = new ArrayList(orderedRecastMap.values());
        }
        List<String> fields = new ArrayList<String>(8);
        for (Map<String, Object> recast : newRecasts) {
            String name = (String)recast.get("name");
            if (("filter".equals(name) || "measure".equals(name) || "having".equals(name) || "sort".equals(name) || "limit".equals(name)) && (recast.get("condition") == null || recast.get("condition") instanceof List && CollectionUtils.isEmpty((Collection)((Collection)recast.get("condition"))) || recast.get("condition") instanceof Map && CollectionUtils.isEmpty((Map)((Map)recast.get("condition"))))) continue;
            if ("filter".equals(name)) {
                stepElements.add(StepElement.buildFilter("filter_" + ++stepIndex, (Map)recast.get("condition")));
                continue;
            }
            if ("measure".equals(name)) {
                TranCovertUtils.buildDistinctField(fields, (Map)recast.get("condition"));
                stepElements.add(StepElement.buildGroup("group_" + ++stepIndex, (Map)recast.get("condition")));
                if (CollectionUtils.isEmpty(fields)) continue;
                stepElements.add(StepElement.buildDistinct("distinct_" + ++stepIndex, fields));
                continue;
            }
            if ("distinct".equals(name)) {
                fields = (List)recast.get("fields");
                stepElements.add(StepElement.buildDistinct("distinct_" + ++stepIndex, fields));
                continue;
            }
            if ("calculate".equals(name)) {
                if (recast.get("rule") == null || CollectionUtils.isEmpty((Collection)((Collection)recast.get("rule")))) continue;
                stepElements.add(StepElement.buildCalculate("calculate_" + ++stepIndex, (List)recast.get("rule")));
                continue;
            }
            if ("having".equals(name)) {
                stepElements.add(StepElement.buildHaving("having_" + ++stepIndex, (Map)recast.get("condition")));
                continue;
            }
            if ("sort".equals(name)) {
                stepElements.add(StepElement.buildGroup("group-sort_" + ++stepIndex, (Map)recast.get("condition")));
                continue;
            }
            if ("limit".equals(name)) {
                stepElements.add(StepElement.buildGroup("group-limit_" + ++stepIndex, (Map)recast.get("condition")));
                continue;
            }
            if ("seqNo".equals(name)) {
                stepElements.add(StepElement.buildGroup("group-seqNo_" + ++stepIndex, (Map)recast.get("condition")));
                continue;
            }
            if (!"choose".equals(name) || recast.get("fields") == null || recast.get("fields") instanceof Map || recast.get("fields") instanceof List && CollectionUtils.isEmpty((Collection)((Collection)recast.get("fields")))) continue;
            stepElements.add(StepElement.buildChoose("group-choose_" + ++stepIndex, (String)recast.get("type"), (List)recast.get("fields")));
        }
        microTrans.setStep(stepElements);
        microTrans.setOrder(MicroTrans.buildOrderListByStepList(stepElements));
        return microTrans;
    }

    public static Object runTransByRecast(List<Map<String, Object>> recasts, Object data, String tenantId) {
        try {
            MicroTrans microTrans = TranCovertUtils.buildTransByRecast(recasts);
            TransDataManger transDataManger = new TransDataManger(JsonUtil.getObject(JsonUtil.getJsonString(microTrans)), data, tenantId);
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
            return transEngine.runEngine(transDataManger);
        }
        catch (Exception e) {
            LOGGER.error("\u539f\u6570\u636e\uff1a" + JsonUtil.getJsonString(data) + "recasts\uff1a" + JsonUtil.getJsonString(recasts));
            e.printStackTrace();
            return "";
        }
    }

    private static void buildDistinctField(List<String> fields, Map<String, Object> conditions) {
        GroupElement groupElement = JsonUtil.getObject(JsonUtil.getJsonString(conditions), GroupElement.class);
        fields.addAll(groupElement.getFields());
        List<Statistic> statistics = groupElement.getStatistics();
        for (Statistic statistic : statistics) {
            if (!"count".equals(statistic.getStatisticalMethod()) && !"sum".equals(statistic.getStatisticalMethod()) && !"average".equals(statistic.getStatisticalMethod()) && !"min".equals(statistic.getStatisticalMethod()) && !"max".equals(statistic.getStatisticalMethod())) continue;
            fields.add(statistic.getNewField());
        }
    }

    public static Object buildPullingData(Object transData) {
        HashMap responseData = new HashMap(1);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        if (transData instanceof List) {
            JSONArray objects = JsonUtil.getList(JsonUtil.getJsonString(transData));
            JSONArray newObjects = new JSONArray();
            for (int i = 0; i < objects.size(); ++i) {
                JSONObject object = objects.getJSONObject(i);
                if (!data.keySet().contains("start_time") && object.get((Object)"start_time") != null) {
                    data.put("start_time", object.get((Object)"start_time"));
                }
                if (!data.keySet().contains("end_time") && object.get((Object)"end_time") != null) {
                    data.put("end_time", object.get((Object)"end_time"));
                }
                newObjects.add((Object)object);
            }
            data.put("data", newObjects);
            responseData.put("data", data);
            LOGGER.error("\u4e8c\u6b21\u8ba1\u7b97\u7684data\uff1a{" + JsonUtil.getJsonString(responseData) + " }");
            return data;
        }
        return transData;
    }

    public static MicroTrans buildTransByJsonArray(JSONArray microTrans) {
        return null;
    }
}

