package com.digiwin.athena.executionengine.service.facade.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/10/22
 */
@Service
public class SortConvertor extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        if (dynamicSchema == null) {
            return;
        }

        JSONArray sort = null;
        if (dynamicSchema instanceof JSONArray) {
            sort = (JSONArray) dynamicSchema;
        } else if (dynamicSchema instanceof List) {
            sort = JSONArray.parseArray(JSONObject.toJSONString(schemaTransDto.getDynamicSchema()));
        }
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Map<String, String> mapping = getReversalShowFieldMapping(querySchema);

        boolean fieldMatch = sort.stream().map(o -> (JSONObject) o).map(item -> item.getJSONObject("dataObject"))
                .anyMatch(item -> mapping.containsKey(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT)));
        if (!fieldMatch) {
            return;
        }
        JSONArray newSort = new JSONArray();
        sort.forEach(item -> {
            JSONObject jsonObject = (JSONObject) item;
            JSONObject dataObject = jsonObject.getJSONObject("dataObject");
            String field = dataObject.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
            String order = jsonObject.getString("order");
            String showField = mapping.get(field);
            JSONObject sortSchemaObj = new JSONObject();
            if (StringUtils.isNotBlank(showField)) {
                sortSchemaObj.put("field", showField);
                sortSchemaObj.put("order", order);
            }
            newSort.add(sortSchemaObj);
        });
        querySchema.getJSONArray("sortFields").addAll(newSort);
    }
}
