package com.digiwin.athena.executionengine.trans;

import com.digiwin.athena.executionengine.model.trans.OrderElement;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/9/1
 */
public class StepLine {
    /**
     * trans规则定义中的两个部分，order和step实体对象集合
     */
    private List<StepElement> stepElementList;
    /**
     * OrderElement 集合
     */
    private List<OrderElement> orderElementList;

    /**
     * orderFromIndex
     */
    private Multimap<String, OrderElement> orderFromIndex = ArrayListMultimap.create();
    /**
     * orderToIndex
     */
    private Multimap<String, OrderElement> orderToIndex = ArrayListMultimap.create();

    /**
     * 通过解析trans定义中创建的，当前即将被执行的trans组件实体对象
     * key：step.name
     * value: step实例
     */
    private Map<String, Step> stepMap = new HashMap<>();

    /**
     * 起始step 可能会有多个
     */
    private List<Step> startStepList;

    public void setStepMap(Map<String, Step> stepMap) {
        this.stepMap = stepMap;
    }

    public List<Step> getStartStepList() {
        return startStepList;
    }

    public void setStartStepList(List<Step> startStepList) {
        this.startStepList = startStepList;
    }

    public Step getEndStep() {
        return endStep;
    }

    public void setEndStep(Step endStep) {
        this.endStep = endStep;
    }

    /**
     * 终止step
     */
    private Step endStep;

    public List<StepElement> getStepElementList() {
        return stepElementList;
    }

    public void setStepElementList(List<StepElement> stepElementList) {
        this.stepElementList = stepElementList;
    }

    public List<OrderElement> getOrderElementList() {
        return orderElementList;
    }

    public void setOrderElementList(List<OrderElement> orderElementList) {
        this.orderElementList = orderElementList;
    }

    public Multimap<String, OrderElement> getOrderFromIndex() {
        return orderFromIndex;
    }

    public void setOrderFromIndex(Multimap<String, OrderElement> orderFromIndex) {
        this.orderFromIndex = orderFromIndex;
    }

    public Multimap<String, OrderElement> getOrderToIndex() {
        return orderToIndex;
    }

    public void setOrderToIndex(Multimap<String, OrderElement> orderToIndex) {
        this.orderToIndex = orderToIndex;
    }

    public Map<String, Step> getStepMap() {
        return stepMap;
    }
}
