package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.AnalysisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/7/5
 */
@Component("truncateKey")
public class TruncateKeyStep extends TransAbstractStep {

    private static final Logger LOGGER = LoggerFactory.getLogger(TruncateKeyStep.class);


    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();

        Object inputData = getCurrentData(step.getPrevStepNameList());

        if (!isTableStructure(inputData)) {
            LOGGER.error("TruncateKeyStep组件只能处理表状数据，非表状数据需要先执行展平节点！Trans执行 {} 失败，数据结构错误！", step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }

        List<Map<String, Object>> resultList = new ArrayList<>();
        for (Map<String, Object> map : (List<Map<String, Object>>) inputData) {
            Map<String, Object> dataMap = new HashMap<>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                dataMap.put(AnalysisUtils.truncateKey(entry.getKey()), entry.getValue());
            }
            resultList.add(dataMap);
        }
        dealResult.setSuccess(resultList);
        return dealResult;
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }
}
