/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.LogDataDto;
import com.digiwin.athena.executionengine.dto.LogDto;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.ResponseStatusException;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.PlatformServiceUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="EspAction")
public class EspAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(EspAction.class);
    private static final String STD_DATA = "std_data";
    private static final String STD_DATA_PARAMETER = "parameter";
    private static final String STD_DATA_PARAMETER_CALL_ID = "call_id";
    private static final String STD_DATA_PARAMETER_SITE_NO = "site_no";
    private static final String STD_DATA_PARAMETER_ENTERPRISE_NO = "enterprise_no";

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        ResponseModel responseModel = null;
        try {
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            HashMap dataMap = new HashMap();
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            bodyMap.put(STD_DATA, dataMap);
            dataMap.put(STD_DATA_PARAMETER, parameter);
            parameter.put(STD_DATA_PARAMETER_ENTERPRISE_NO, "");
            parameter.put(STD_DATA_PARAMETER_SITE_NO, "");
            parameter.put(STD_DATA_PARAMETER_CALL_ID, UUID.randomUUID().toString());
            parameter.putAll(reqMap);
            RequestModel requestModel = this.getRequestModel(context, bodyMap, actionParam);
            responseModel = PlatformServiceUtils.callEsp(requestModel);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528ESP\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), parameter, responseModel.getBodyJsonString()});
            this.logTrace(responseModel, true);
            JSONObject dataObj = ServiceResponseUtils.getEspRespData(responseModel.getBodyJsonString());
            boolean status = ServiceResponseUtils.getEspRespStatus(dataObj);
            context.setExecuteStatus(status);
            return ServiceResponseUtils.getEspRespParameter(dataObj);
        }
        catch (InvocationException e) {
            this.logTrace(responseModel, false);
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528esp\u6267\u884c{}\u5f02\u5e38:{}", (Object)actionParam.getActionId(), (Object)e);
            ResponseStatusException responseStatusException = new ResponseStatusException(e.getErrorCode(), e.getErrorMessage());
            responseStatusException.getInstructors().put("chainInfo", e.getChainInfo());
            throw responseStatusException;
        }
        catch (Exception e) {
            this.logTrace(responseModel, false);
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528esp\u6267\u884c{}\u5f02\u5e38:{}", (Object)actionParam.getActionId(), (Object)e);
            context.setExecuteStatus(false);
            throw new ResponseStatusException(ErrorCodeEnum.CALL_ESP_EXCEPTION.getCode(), ErrorCodeEnum.CALL_ESP_EXCEPTION.getMessage(), e);
        }
    }

    private RequestModel getRequestModel(ExecuteContext context, Map<String, Object> bodyMap, ActionParam actionParam) {
        String serverName = actionParam.getMetaObj().getString("serviceName");
        String productName = actionParam.getActionJson().getString("productName");
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("ExecutionEngine");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("ExecutionEngine");
        requestModel.setHostAcct("athena");
        requestModel.setServiceName(serverName);
        requestModel.setBodyJsonString(JsonResolverUtils.toJsonString(bodyMap));
        requestModel.setTenantId(context.getTenantId());
        requestModel.setServiceProd(productName);
        requestModel.setLanguage(context.getLocale());
        HashMap<String, String> header = new HashMap<String, String>();
        DWServiceChainUtils.beforeInvokeOutterAPI(header::put);
        header.put("token", context.getToken());
        header.put("routerKey", context.getRouterKey());
        header.put("digi-middleware-auth-app", ModuleProperty.APP_TOKEN_VALUE);
        requestModel.setHeaderMap(header);
        requestModel.setEocMap(context.getEocMap());
        if (context.getLocale() != null) {
            requestModel.setLanguage(context.getLocale());
        }
        HashMap datakeymap = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)context.getApplication())) {
            datakeymap.put("appCode", context.getApplication());
        }
        if (StringUtils.isNotBlank((CharSequence)context.getTaskType())) {
            datakeymap.put("taskType", context.getTaskType());
        }
        if (StringUtils.isNotBlank((CharSequence)context.getTaskCode())) {
            datakeymap.put("taskCode", context.getTaskCode());
        }
        if (MapUtils.isNotEmpty((Map)datakeymap)) {
            requestModel.setDatakeyMap((Map)datakeymap);
        }
        return requestModel;
    }

    private void logTrace(ResponseModel responseModel, boolean success) {
        if (responseModel == null) {
            return;
        }
        String message = success ? "\u8c03\u7528esp\u6210\u529f" : "\u8c03\u7528esp\u5f02\u5e38";
        LogDataDto logDataDto = new LogDataDto(responseModel.getReqid(), "esp\u8bf7\u6c42id", "link", "esp");
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            LOGGER.info(logDto.toString());
        } else {
            LOGGER.error(logDto.toString());
        }
    }
}

