package com.digiwin.athena.executionengine.model;

import java.io.Serializable;

/**
 * 基础的分页参数
 * @author wuyang
 */
public class BasePage implements Serializable {

    private static final long serialVersionUID = 1281345852925019648L;

    public static final int DEFAULT_PAGE_SIZE = 10000;
    public static final int MAX_DATA_SIZE = 150000;

    /**
     * 分页页码
     */
    private Integer pageNo;
    /**
     * 分页笔数
     */
    private Integer pageSize;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public BasePage() {
    }

    public BasePage(Integer pageNo, Integer pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    /**
     * 执行引擎默认分页参数为1次取1万笔
     * @return
     */
    public static BasePage createDefaultPage(){
        return new BasePage(1, DEFAULT_PAGE_SIZE);
    }
}
