package com.digiwin.athena.executionengine.model.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.model.DataDescription;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 执行引擎接收入参对象
 * @author: renwm
 * @date: 2020/6/18 16:53
 */
public class InputParamModule {
    private String actionId;
    private String tenantId;
    private List<Map<String, Object>> paras;
    private Map<String, Object> param;

    private List<Map<String, Object>> eocMaps;
    private List<String> roles;

    public List<Map<String, Object>> getEocMaps() {
        return eocMaps;
    }

    public void setEocMaps(List<Map<String, Object>> eocMaps) {
        this.eocMaps = eocMaps;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    /**
     * 用于解析paras或者param的，方便代码处理
     * 在入参分析结束以后会清空
     */
    @JSONField(serialize = false)
    private Map<String, Object> inputParam;
    private Map<String, Object> eocMap;
    private Map<String, Object> sysParam;

    private Map<String, Object> mockData;

    private DataDescription dataDescription;

    public Map<String, Object> getMockData() {
        return mockData;
    }

    public InputParamModule() {
    }

    /**
     * 通过构建器创建InputParamModule对象，隔离与接口的多样性
     *
     * @param inputParamModuleBuilder 构建器对象
     */
    public InputParamModule(InputParamModuleBuilder inputParamModuleBuilder) {

        this.mockData = inputParamModuleBuilder.getMockData();
        this.actionId = inputParamModuleBuilder.getActionId();
        this.tenantId = inputParamModuleBuilder.getTenantId();
        this.eocMap = inputParamModuleBuilder.getEocMap();
        if (inputParamModuleBuilder.getDataDescription() != null) {
            this.dataDescription = inputParamModuleBuilder.getDataDescription();
        }

        if (inputParamModuleBuilder.getParas() != null) {
            this.paras = inputParamModuleBuilder.getParas();
            inputParam = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
            inputParam.put(FieldNameConstant.INPUT_PARAM_PARAS, this.paras);
        }

        if (inputParamModuleBuilder.getParam() != null) {
            this.param = inputParamModuleBuilder.getParam();
            inputParam = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
            inputParam.put(FieldNameConstant.INPUT_PARAM_PARAM, this.param);
        }
        if (inputParamModuleBuilder.getSysParam() != null) {
            sysParam = inputParamModuleBuilder.getSysParam();
        }
        this.eocMaps = inputParamModuleBuilder.getEocMaps();
        this.roles = inputParamModuleBuilder.getRoles();
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, Object> getEocMap() {
        return eocMap;
    }

    public void setEocMap(Map<String, Object> eocMap) {
        this.eocMap = eocMap;
    }

    public List<Map<String, Object>> getParas() {
        return paras;
    }

    public void setParas(List<Map<String, Object>> paras) {
        this.paras = paras;
    }

    public Map<String, Object> getParam() {
        return param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public Map<String, Object> getInputParam() {
        return inputParam;
    }

    public void setInputParam(Map<String, Object> inputParam) {
        this.inputParam = inputParam;
    }

    public Map<String, Object> getSysParam() {
        return sysParam;
    }

    public void setSysParam(Map<String, Object> sysParam) {
        this.sysParam = sysParam;
    }

    public DataDescription getDataDescription() {
        return dataDescription;
    }


    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}