package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.dto.DataCenterDto;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.BasePage;
import com.digiwin.athena.executionengine.service.client.IDataCenterClient;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/5/12
 */
@Service("engineDataCenterClient")
public class DataCenterClient implements IDataCenterClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataCenterClient.class);

    @Override
    public JSONArray getDataCenterData(DataCenterDto dataCenterDto) {
        JSONArray list = new JSONArray();
        int pageNo = 1;
        long startTime = System.currentTimeMillis();
        try {
            while (true) {
                dataCenterDto.setPageNo(pageNo);
                //分页设置
                JSONObject data = doQuery(dataCenterDto);
                if (data == null || data.isEmpty()) {
                    break;
                }
                JSONObject dataNode = data.getJSONObject("data");
                if (dataNode == null) {
                    break;
                }

                Integer total = Integer.parseInt(dataNode.getString("totalCount"));
                if (total == 0) {
                    break;
                }

                if (total >= BasePage.MAX_DATA_SIZE) {
                    throw new BusinessException(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW);
                }

                list.addAll(dataNode.getJSONArray("list"));

                if (list.size() >= total) {
                    break;
                }

                pageNo++;
            }
        } catch (Exception e) {
            LOGGER.error(String.format("调用数据中台查询异常，modelCode：%s,查询schema:%s", dataCenterDto.getModelCode(), list.size(), dataCenterDto.getQuerySchema()));
        }


        long timeTaken = (System.currentTimeMillis() - startTime);
        LOGGER.info(String.format("modelCode：%s，查询耗时:%sms，查询笔数:%s,查询schema:%s", dataCenterDto.getModelCode(), timeTaken, list.size(), dataCenterDto.getQuerySchema()));
        LogUtils.buildAgileLog(LogConstant.AGILE_CODE_EXECUTE_SQL_ACTION, LogUtils.SUCCESS, "modelId:" + dataCenterDto.getModelId() + "，查询方案:" + dataCenterDto.getQuerySchema(), "数据笔数：" + list.size(), "");
        return list;
    }


    private JSONObject doQuery(DataCenterDto dataCenterDto) {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("token", dataCenterDto.getToken());
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, dataCenterDto.getRouterKey());
        headerMap.put("Accept", "application/json;charset=UTF-8");
        Map<String, Object> param = new HashMap<>();
        param.put("orderColumn", dataCenterDto.getOrderColumn());
        param.put("pageNum", dataCenterDto.getPageNo());
        param.put("pageSize", dataCenterDto.getPageSize());
        param.put("modelId", dataCenterDto.getModelId());
        param.put("modelCode", dataCenterDto.getModelCode());
        param.put("totalEnable", true);
        param.put("queryInfo", dataCenterDto.getQuerySchema());

        String jsonParam = JsonResolverUtils.toJsonString(param);
        String httpRespContent = HttpClientUtils.doPost(DatasourceUrl.dcpUrl + "/api/ddl/data-platform/api/datasets", headerMap, jsonParam);
        return JSONObject.parseObject(httpRespContent);
    }
}
