package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class JoinTransformer implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {

        JSONObject variable = new JSONObject();

        variable.put("technique", "join");
        variable.put("joinType", schema.getString("joinType"));
        JSONArray onConditions = schema.getJSONArray("on");
        JSONArray leftFields = new JSONArray();
        JSONArray rightFields = new JSONArray();

        onConditions.forEach(item -> {
            JSONObject itemObj = (JSONObject) item;
            leftFields.add(itemObj.getJSONObject("left").getString("content"));
            rightFields.add(itemObj.getJSONObject("right").getString("content"));
        });
        variable.put("leftFields", leftFields);
        variable.put("rightFields", rightFields);

        return variable;
    }
}
