package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 结构展平组件
 * @author: fenglei
 * @date: 2020-12-3
 */
@Component("spread")
public class SpreadStep extends TransAbstractStep {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadStep.class);

    /**
     * @return 结构展平组件返回值结构是：List<Map<String, Object>>
     * @throws Exception
     */
    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            //生成的是List<Map<String,Object>>结构

            Object inputData = getCurrentData(step.getPrevStepNameList());
            //input数据可能是表状数据也可能是层次数据，如果是空的集合或者map，需要直接返回一个空的表状数据出去
            if (inputData instanceof Map && MapUtils.isEmpty((Map) inputData)) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }

            if (inputData instanceof List && CollectionUtils.isEmpty((List) inputData)) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }

            Map<String, Object> input = new HashMap<>();
            input.put("", inputData);
            dealResult.setSuccess(enterStruct("", input));
            return dealResult;
        } catch (Exception e) {
            LOGGER.error("展平组件执行异常");
            throw e;
        }
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    //得到一个list<Map>替换传入的结构
    /*
     * mapKey 和当前结构对应的json中的key
     * cMap   结构内容
     */
    public List<Map<String, Object>> enterStruct(String mapKey, Map<String, Object> cMap) {

        boolean hasList = findListInMap(cMap);
        boolean hasMap = findMapInMap(cMap);

        if (hasList || hasMap) {
            if (hasList) {

                String listKey = existListKeyInMap(cMap);

                List<Map<String, Object>> list = new ArrayList<>();

                if (((List<Object>) cMap.get(listKey)).size() == 0) {
                    throw new BusinessException("spreadStep data not found,key：" + listKey);
                }

                if (findMapInList((List<Object>) cMap.get(listKey))) {
                    for (Object obj : (List<Object>) cMap.get(listKey)) {
                        list.addAll(enterStruct(listKey, (Map<String, Object>) obj));
                    }
                } else {
                    list.addAll(setMapList((List<Map<String, Object>>) cMap.get(listKey)));
                }


                Map<String, Object> otherFields = spreadObjectInFields(cMap, listKey);
                return insteadOf(cMap, list, listKey, otherFields);
            } else {

                String listKey = existMapKeyInMap(cMap);
                List<Map<String, Object>> list = enterStruct(listKey, (Map<String, Object>) cMap.get(listKey));

                Map<String, Object> otherFields = spreadObjectInFields(cMap, listKey);
                return insteadOf(cMap, list, listKey, otherFields);
            }

        } else {

            List<Map<String, Object>> rtn = new ArrayList<>();
            rtn.add(cMap);

            return rtn;
        }
    }

    public List<Map<String, Object>> setMapList(List<Map<String, Object>> list) {
        List<Map<String, Object>> rtn = new ArrayList<>();

        for (Object obj : list) {
            Map<String, Object> field = new HashMap<>();
            field.put("", obj);
            rtn.add(field);
        }

        return rtn;
    }

    public Map<String, Object> spreadObjectInFields(Map<String, Object> mMap, String listKey) {
        Map<String, Object> otherFields = getOtherFields(mMap, listKey);
        Map<String, Object> rtn;

        if (findMapInMap(otherFields)) {
            rtn = new HashMap<>();
            for (Map.Entry<String, Object> entry : otherFields.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    rtn.putAll(setFatherKeyIntoObjectKey(entry.getKey(), (Map<String, Object>) entry.getValue()));
                } else {
                    rtn.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            rtn = otherFields;
        }

        return rtn;
    }

    /*
     * mMap 含有待替换的层次结构
     * list 已展平的明细部分
     * listKey 展平的明细部分在cMap中的JsonKey
     */
    public List<Map<String, Object>> insteadOf(Map<String, Object> mMap, List<Map<String, Object>> list, String listKey, Map<String, Object> otherFields) {

        List<Map<String, Object>> rtn = new ArrayList<>(list.size());
        for (Map<String, Object> obj : list) {
            rtn.add(concatMap(setFatherKeyIntoObjectKey(listKey, obj), otherFields));
        }

        if (list.size() == 0) {
            Map<String, Object> tmpMap = new HashMap<>();
            tmpMap.put(listKey, null);
            rtn.add(concatMap(tmpMap, otherFields));
        }

        return rtn;
    }

    public Map<String, Object> concatMap(Map<String, Object> subMap, Map<String, Object> otherFields) {
        subMap.putAll(otherFields);
        return subMap;
    }

    public Map<String, Object> getOtherFields(Map<String, Object> mMap, String cleanKey) {
        Map<String, Object> cMap = new HashMap<>(mMap.size() - 1);
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getKey().equals(cleanKey)) {
                continue;
            }
            cMap.put(entry.getKey(), entry.getValue());
        }
        return cMap;
    }

    public boolean findMapInList(List<Object> mList) {

        for (Object obj : mList) {
            if (obj instanceof Map) {
                return true;
            } else {
                break;
            }
        }

        return false;
    }

    public boolean findListInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                return true;
            }
        }

        return false;
    }

    public boolean findMapInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                return true;
            }
        }

        return false;
    }

    public String existListKeyInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                return entry.getKey();
            }
        }

        return "";
    }


    public String existMapKeyInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                return entry.getKey();
            }
        }

        return "";
    }

    //fatherKey:{A:a,B:b...}  => {fatherKey.A:a, fatherKey.B:b,...}
    public Map<String, Object> setFatherKeyIntoObjectKey(String fatherKey, Map<String, Object> mMap) {
        Map<String, Object> rtn = new HashMap<>();

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            rtn.put(setPathKey(fatherKey, entry.getKey()), entry.getValue());
        }
        return rtn;
    }

    public String setPathKey(String fatherKey, String currentKey) {
        String symbol = ".";
        if (fatherKey.isEmpty() || currentKey.isEmpty()) {
            symbol = "";
        }

        return fatherKey + symbol + currentKey;
    }
}
