/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.aop.ExceptionRetry;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="EocAction")
public class EocAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(EocAction.class);
    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String RESPONSE_CODE = "code";

    @Override
    @ExceptionRetry
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString("url");
        String method = metaObj.getString("method");
        JSONObject actionJson = actionParam.getActionJson();
        String allocateType = actionJson.getString("allocateType");
        try {
            JSONArray jsonArrayData;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put(DIGI_MIDDLEWARE_AUTH_USER, context.getToken());
            header.put("Content-Type", "application/json;charset=UTF-8");
            String iamApToken = ModuleProperty.APP_TOKEN_VALUE;
            if (StringUtils.isEmpty((CharSequence)iamApToken)) {
                iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
            }
            header.put("digi-middleware-auth-app", iamApToken);
            String actionUrl = ModuleProperty.EOC_DOMAIN_URL + url;
            String httpContent = HttpClientUtils.doRequest(method, actionUrl, header, reqMap);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528EOC\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionUrl, reqMap, httpContent});
            if (StringUtils.isBlank((CharSequence)httpContent)) {
                return null;
            }
            JSONObject respObj = JSON.parseObject((String)httpContent);
            if (200 != respObj.getIntValue(RESPONSE_CODE)) {
                context.setExecuteStatus(false);
                return null;
            }
            if ("RANDOM".equals(allocateType) && null != (jsonArrayData = respObj.getJSONArray("data")) && jsonArrayData.size() > 1) {
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(jsonArrayData.get(ThreadLocalRandom.current().nextInt(jsonArrayData.size() - 1)));
                respObj.put("data", (Object)jsonArray);
            }
            context.setExecuteStatus(true);
            return respObj;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u89e6\u53d1EOC[{}]\u5f02\u5e38:{}", (Object)url, (Object)e);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}

