/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.NumberRangeRuleElement;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.service.client.impl.ThemeMapClient;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="numberRange")
public class NumberRangeStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberRangeStep.class);
    private ThemeMapClient themeMapClient;

    @Resource
    public void setThemeMapClient(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        if (StringUtils.isEmpty((CharSequence)stepElement.getNewField()) || StringUtils.isEmpty((CharSequence)stepElement.getColumn())) {
            return false;
        }
        List<NumberRangeRuleElement> rules = stepElement.getRule();
        for (NumberRangeRuleElement rule : rules) {
            if ("var".equalsIgnoreCase(rule.getLowerType()) || "commonvar".equalsIgnoreCase(rule.getLowerType()) || "column".equalsIgnoreCase(rule.getLowerType()) || "var".equalsIgnoreCase(rule.getUpperType()) || "commonvar".equalsIgnoreCase(rule.getUpperType()) || "column".equalsIgnoreCase(rule.getUpperType())) {
                return true;
            }
            if ("rightOpenRange".equals(rule.getDecision())) {
                if (!StringUtils.isEmpty((CharSequence)rule.getLower()) && (!StringUtils.isNotEmpty((CharSequence)rule.getUpper()) || this.isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper())))) continue;
                return false;
            }
            if ("leftOpenRange".equals(rule.getDecision())) {
                if (!StringUtils.isEmpty((CharSequence)rule.getUpper()) && (!StringUtils.isNotEmpty((CharSequence)rule.getLower()) || this.isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper())))) continue;
                return false;
            }
            if ("closeRange".equals(rule.getDecision())) {
                if (StringUtils.isEmpty((CharSequence)rule.getLower()) || StringUtils.isEmpty((CharSequence)rule.getUpper())) {
                    return false;
                }
                if (this.isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper()))) continue;
                return false;
            }
            if ("openRange".equals(rule.getDecision())) {
                if (!StringUtils.isEmpty((CharSequence)rule.getLower()) || !StringUtils.isEmpty((CharSequence)rule.getUpper())) continue;
                return false;
            }
            if ("equal".equals(rule.getDecision())) {
                if (!StringUtils.isEmpty((CharSequence)rule.getLower())) continue;
                return false;
            }
            if ("notEqual".equals(rule.getDecision())) {
                if (!StringUtils.isEmpty((CharSequence)rule.getLower())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = this.getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.warn("NumberRangeStep\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        List dataList = (List)inputData;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }
        StepElement stepElement = step.getStepElement();
        List<NumberRangeRuleElement> rules = stepElement.getRule();
        for (Map data : dataList) {
            Object column = data.get(stepElement.getColumn());
            String strColumn = String.valueOf(column);
            if ("null".equals(strColumn) || StringUtils.isEmpty((CharSequence)strColumn)) {
                strColumn = "0";
            }
            if ("false".equalsIgnoreCase(strColumn) || "true".equalsIgnoreCase(strColumn)) {
                strColumn = "false".equalsIgnoreCase(strColumn) ? "0" : "1";
            }
            this.setValueByRule(stepElement, data, rules, new BigDecimal(strColumn));
        }
        dealResult.setSuccess(dataList);
        return dealResult;
    }

    private void setValueByRule(StepElement stepElement, Map<String, Object> data, List<NumberRangeRuleElement> rules, BigDecimal column) {
        String value = stepElement.getDefaultValue();
        if ("column".equalsIgnoreCase(stepElement.getDefaultValueType())) {
            value = String.valueOf(data.get(stepElement.getDefaultValue()));
        }
        for (NumberRangeRuleElement rule : rules) {
            ArrayList<String> commonVarParamList = new ArrayList<String>();
            if ("commonvar".equalsIgnoreCase(rule.getLowerType())) {
                commonVarParamList.add(rule.getLower());
            }
            if ("commonvar".equalsIgnoreCase(rule.getUpperType())) {
                commonVarParamList.add(rule.getUpper());
            }
            if ("commonvar".equalsIgnoreCase(rule.getValueType())) {
                commonVarParamList.add(rule.getValue());
            }
            HashMap<String, Object> commonVarMap = this.getTransDataManager().getCommonVarCollection();
            if (CollectionUtils.isNotEmpty(commonVarParamList)) {
                JSONObject respData = this.themeMapClient.querySmartDataVariable(this.getTransDataManager().getTenantId(), commonVarParamList, this.getTransDataManager().getToken());
                HashMap<String, Object> finalCommonVarMap = commonVarMap = commonVarMap == null ? new HashMap<String, Object>() : commonVarMap;
                commonVarParamList.forEach(numberRangeItem -> finalCommonVarMap.put((String)numberRangeItem, Optional.ofNullable(respData).map(item -> item.get(numberRangeItem)).orElse(null)));
                this.getTransDataManager().setCommonVarCollection(commonVarMap);
            }
            BigDecimal lower = null;
            if (StringUtils.isNotEmpty((CharSequence)rule.getLower()) && !"commonvar".equalsIgnoreCase(rule.getLowerType()) && !"var".equalsIgnoreCase(rule.getLowerType()) && !"column".equalsIgnoreCase(rule.getLowerType())) {
                lower = new BigDecimal("boolean".equalsIgnoreCase(rule.getLowerDataType()) ? ("true".equalsIgnoreCase(rule.getLower()) ? "1" : "0") : rule.getLower());
            } else if ("commonvar".equalsIgnoreCase(rule.getLowerType())) {
                lower = this.getCommonVarValue(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(this.getCommonVarValue(rule.getLower())));
            } else if ("var".equalsIgnoreCase(rule.getLowerType())) {
                lower = this.getTransDataManager().getMechanismData(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(this.getTransDataManager().getMechanismData(rule.getLower())));
            } else if (StringUtils.isNotEmpty((CharSequence)rule.getLower()) && "column".equalsIgnoreCase(rule.getLowerType())) {
                lower = data.get(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(data.get(rule.getLower())));
            } else if ("systemvar".equalsIgnoreCase(rule.getLowerType())) {
                lower = new BigDecimal(this.getSystemVarValue(rule.getLower()));
            }
            BigDecimal upper = null;
            if (StringUtils.isNotEmpty((CharSequence)rule.getUpper()) && !"commonvar".equalsIgnoreCase(rule.getUpperType()) && !"var".equalsIgnoreCase(rule.getUpperType()) && !"column".equalsIgnoreCase(rule.getUpperType())) {
                upper = new BigDecimal("boolean".equalsIgnoreCase(rule.getUpperDataType()) ? ("true".equalsIgnoreCase(rule.getUpper()) ? "1" : "0") : rule.getUpper());
            } else if ("commonvar".equalsIgnoreCase(rule.getUpperType())) {
                upper = this.getCommonVarValue(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(this.getCommonVarValue(rule.getUpper())));
            } else if ("var".equalsIgnoreCase(rule.getUpperType())) {
                upper = this.getTransDataManager().getMechanismData(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(String.valueOf(this.getTransDataManager().getMechanismData(rule.getUpper()))));
            } else if (StringUtils.isNotEmpty((CharSequence)rule.getUpper()) && "column".equalsIgnoreCase(rule.getUpperType())) {
                upper = data.get(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(data.get(rule.getUpper())));
            } else if ("systemvar".equalsIgnoreCase(rule.getUpperType())) {
                upper = new BigDecimal(this.getSystemVarValue(rule.getUpper()));
            }
            boolean defaultFlag = true;
            String decision = rule.getDecision();
            if ("rightOpenRange".equals(decision)) {
                if (upper == null && this.isGreaterThanOrEqual(lower, column) || upper != null && this.isGreaterThanOrEqual(lower, column) && this.isLessThan(column, upper)) {
                    value = this.getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if ("leftOpenRange".equals(decision)) {
                if (lower == null && this.isLessThanOrEqual(column, upper) || lower != null && this.isGreaterThan(lower, column) && this.isLessThanOrEqual(column, upper)) {
                    value = this.getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if ("closeRange".equals(decision)) {
                if (this.isGreaterThanOrEqual(lower, column) && this.isLessThanOrEqual(column, upper)) {
                    value = this.getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if ("openRange".equals(decision)) {
                if (lower == null && this.isLessThan(column, upper) || upper == null && lower != null && this.isGreaterThan(lower, column) || upper != null && lower != null && this.isGreaterThan(lower, column) && this.isLessThan(column, upper)) {
                    value = this.getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if ("equal".equals(decision)) {
                if (lower != null && this.isEqual(lower, column)) {
                    value = this.getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if ("notEqual".equals(decision) && lower != null && this.isNotEqual(lower, column)) {
                value = this.getRangeValue(rule, data);
                defaultFlag = false;
            }
            if (defaultFlag) {
                if ("column".equalsIgnoreCase(stepElement.getDefaultValueType())) {
                    data.put(stepElement.getNewField(), data.get(stepElement.getDefaultValue()));
                    continue;
                }
                data.put(stepElement.getNewField(), ("constant".equalsIgnoreCase(stepElement.getDefaultValueType()) || StringUtils.isEmpty((CharSequence)stepElement.getDefaultValueType())) && "number".equalsIgnoreCase(stepElement.getDefaultValueDataType()) ? new BigDecimal(value) : value);
                continue;
            }
            data.put(stepElement.getNewField(), ("constant".equalsIgnoreCase(rule.getValueType()) || StringUtils.isEmpty((CharSequence)rule.getValueType())) && "number".equalsIgnoreCase(rule.getValueDataType()) ? new BigDecimal(value) : value);
        }
    }

    private String getRangeValue(NumberRangeRuleElement rule, Map<String, Object> data) {
        if ("commonvar".equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(this.getCommonVarValue(rule.getValue()) == null ? "" : this.getCommonVarValue(rule.getValue()));
        }
        if ("var".equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(this.getTransDataManager().getMechanismData(rule.getValue()));
        }
        if ("column".equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(data.get(rule.getValue()));
        }
        if ("systemvar".equalsIgnoreCase(rule.getValueType())) {
            return this.getSystemVarValue(rule.getValue());
        }
        return rule.getValue();
    }

    private boolean isGreaterThanOrEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && !this.isLessThan(column, compareValue);
    }

    private boolean isEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && !this.isNotEqual(compareValue, column);
    }

    private boolean isNotEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && compareValue.compareTo(column) != 0;
    }

    private boolean isLessThan(BigDecimal column, BigDecimal compareValue) {
        return compareValue != null && column.compareTo(compareValue) < 0;
    }

    private boolean isLessThanOrEqual(BigDecimal column, BigDecimal compareValue) {
        return compareValue != null && !this.isGreaterThan(compareValue, column);
    }

    private boolean isGreaterThan(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && compareValue.compareTo(column) < 0;
    }

    private Object getCommonVarValue(String key) {
        JSONObject commonVar;
        String status;
        Map<String, Object> commonVarMap = this.getTransDataManager().getCommonVarCollection();
        if (commonVarMap != null && commonVarMap.get(key) != null && "1".equals(status = (commonVar = (JSONObject)commonVarMap.get(key)).getString("status"))) {
            return ((JSONObject)commonVarMap.get(key)).get((Object)"value");
        }
        return null;
    }

    private String getSystemVarValue(String systemVarName) {
        switch (systemVarName) {
            case "s_runTime": {
                return DateUtils.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
            }
            case "s_runDate": {
                return DateUtils.getCurrentDateTime("yyyy-MM-dd");
            }
            case "s_userName": {
                return this.getTransDataManager().getLoginUserName();
            }
            case "s_userId": {
                return this.getTransDataManager().getUserId();
            }
        }
        return systemVarName;
    }
}

