package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.core.container.RunInfo;
import com.digiwin.athena.executionengine.dto.runinfo.ActionExecutionDto;
import com.digiwin.athena.executionengine.dto.runinfo.DebugDto;
import com.digiwin.athena.executionengine.dto.runinfo.MetricExecutionDto;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/12
 */

@Service("MetricAction")
public class MetricAction extends ActionBase {


    private static final Logger LOGGER = LoggerFactory.getLogger(MetricAction.class);

    @Debug
    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject respObj = null;
        try {
            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, context.getRouterKey());
            headerMap.put(MetaDataConstant.ACTION_LOCALE, context.getLocale());

            Map<String, Object> param = new HashMap<>();
            param.put("actionId", actionParam.getActionId());
            param.put("tenantId", context.getTenantId());
            param.put("eocMaps", context.getInputParam().getEocMaps());
            param.put("roles", context.getInputParam().getRoles());
            param.put("sysParam", context.getInputParam().getSysParam());
            param.put("dataDescription", context.getInputParam().getDataDescription());
            param.put("param", new HashMap<>());

            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.EE_URL, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("执行引擎调用指标Action执行{}:{}返回的结果为：null", actionParam.getActionId(), jsonParam);
                return null;
            }
            LOGGER.info("执行引擎调用指标Action执行{}:{}返回的结果为：{}", actionParam.getActionId(), jsonParam, httpRespContent);
            respObj = ServiceResponseUtils.getServiceComposerResp(httpRespContent);
            context.setExecuteStatus(true);
            if (respObj == null) {
                return new JSONObject();
            }
            if (context.isDebug()) {
                RunInfo runInfo = JSONObject.parseObject(JSONObject.toJSONString(respObj.get("runInfo")), RunInfo.class);
                MetricExecutionDto metricExecutionDto = new MetricExecutionDto();
                String uuid = UUID.randomUUID().toString();
                metricExecutionDto.setUuid(uuid);
                metricExecutionDto.setMetricId(actionParam.getActionId());
                metricExecutionDto.setMetricName(actionParam.getMetaObj().getString("actionName"));
                //runInfo
                context.getRunInfo().getMetricExecutionDto().getChildren().add(metricExecutionDto);

                //存储当前指标对应的detail
                context.getRunInfo().getActionExecutionMap().put(uuid, runInfo.getActionExecutionDtos());
                //存储子指标的
                context.getRunInfo().getActionExecutionMap().putAll(runInfo.getActionExecutionMap());
            }

            return respObj;
        } catch (Exception e) {
            LOGGER.error("执行引擎调用指标Action执行异常", e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0004");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.METRIC);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}
