package com.digiwin.athena.executionengine.constant;

/**
 * @description: 排程统一返回结果定义
 * @author: zhangww
 * @time: 2020/4/16 13:57
 */
public enum ResultStatusConstant {

    /**
     * 成功响应
     */
    SUCCESS(200, "命令执行成功"),

    /**
     * 失败响应
     */
    FAILD(999, "处理失败"),

    /**
     * action未执行
     */
    UN_EXECUTED(0, "action未执行"),
    EXECUTING(1, "action执行中"),

    /**
     * action执行成功
     */
    EXECUTE_SUCCESS(200, "action执行成功"),

    /**
     * action已执行过，直接拿之前执行结果
     */
    EXECUTED_SUCCESS(200, "action已经执行成功，已有数据直接返回"),

    /**
     * action已执行过，直接拿之前执行结果
     */
    EXECUTED_FAILD(999, "action之前已经执行失败，直接返回"),

    /**
     * action执行失败
     */
    EXECUTE_FAILD(999, "action执行失败"),

    /**
     * action执行异常
     */
    EXECUTE_EXCEPTION(500, "action执行异常");

    /**
     * 响应码
     */
    private int code;

    /**
     * 响应描述
     */
    private String desc;

    ResultStatusConstant(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

