/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.LogDataDto;
import com.digiwin.athena.executionengine.dto.LogDto;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.MqSendUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="DataEventAction")
public class DataEventAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataEventAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String dataEventId = actionParam.getMetaObj().getString("dataEventId");
        LOGGER.info("\u4e0a\u4e0b\u6587\u53d6\u5230\u7684locale:{}", (Object)context.getLocale());
        String locale = context.getLocale() != null ? context.getLocale() : actionParam.getActionJson().getString("locale");
        LOGGER.info("\u53d1\u8d77\u4efb\u52a1\u5f15\u64ce\u6700\u7ec8\u4f7f\u7528\u7684locale:{}", (Object)locale);
        JSONObject respObj = null;
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put("routerKey", context.getRouterKey());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("dataEventId", dataEventId);
            param.put("locale", locale);
            param.put("process_EOC", context.getEocMap());
            param.put("variables", reqMap);
            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.TASKENGINE_SERVICE_URL, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)actionParam.getActionId(), (Object)jsonParam);
                return null;
            }
            LOGGER.info("\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), jsonParam, httpRespContent});
            respObj = ServiceResponseUtils.getDataEventResp(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            this.logTrace(respObj, true);
            MqSendUtils.sendSuccessMessage(context, "TaskEngine", param);
            return respObj;
        }
        catch (Exception e) {
            this.logTrace(respObj, false);
            LOGGER.error("\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u5f02\u5e38", (Throwable)e);
            context.setExecuteStatus(false);
            MqSendUtils.sendExceptionMessage(context, e.getMessage());
            throw e;
        }
    }

    private void logTrace(JSONObject respObj, boolean success) {
        String value = Optional.ofNullable(respObj).map(item -> item.getString("serialNumber")).orElse(null);
        LogDataDto logDataDto = new LogDataDto(value, "\u4efb\u52a1\u5f15\u64ce\u6d41\u7a0b\u5e8f\u53f7", "link", "taskEngine");
        String message = success ? "\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u6210\u529f" : "\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u5931\u8d25";
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            LOGGER.info(logDto.toString());
        } else {
            LOGGER.error(logDto.toString());
        }
    }
}

