package com.digiwin.athena.executionengine.constant;

import com.digiwin.app.autoconfigure.merge.listener.DWMultipleAppEnvApplicationStartingListener;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationPropertiesUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: Module资源文件配置实体类对象
 * @author: renwm
 * @date: 2020/4/28 09:02
 */
public final class ModuleProperty {

    private ModuleProperty() {
    }

    /**
     * IAM 登录类型
     */
    public static final String IAM_IDENTITYTYPE = "secretKey";

    /**
     * 当前模组名称
     */
    public static final String CURRENT_MODULE_NAME = "ExecutionEngine";

    /**
     * esp AP_ID
     */
    public static final String ESP_AP_ID = "ExecutionEngine";

    /**
     * esp hostAcct
     */
    public static final String ESP_HOSTACCT = "athena";


    /**
     * IAM 用户登录 路径配置
     */
    public static final String IAM_USERLOGINURL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "iamUserLoginUrl");

    /**
     * IAM 根据token获取用户信息地址
     */
    public static final String IAM_USERINFO_URL = "/api/iam/v2/user/current?withEmp=";

    /****
     * 多环境上下文
     */
    public static final boolean MULTIPLEAPPENV = Boolean.parseBoolean(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME,
        DWMultipleAppEnvApplicationStartingListener.CONFIG_KEY_MULTIPLE_APP_ENV));
    /***
     * 多服务合并获取APP_TOKEN
     */
    public static final String MERGED_IAM_APP_TOKEN = DWApplicationConfigUtils.getProperty("dap.merged.apps."+DWApplicationConfigUtils.getProperty("appId")+".iamApToken", "");

    /**
     * appToken
     */
    public static final String APP_TOKEN_VALUE = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "iamApToken");

    /**
     * Http 最多连接数
     */
    public static final int HTTP_MAXTOTAL = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "httpClientMaxTotal"));
    /**
     * htpp最大路由数量
     */
    public static final int HTTP_MAXPERROUTE = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "httpClientMaxPerRoute"));

    /**
     * htpp 请求超时 时长  毫秒
     */
    public static final int HTTP_REQUEST_TIMEOUT = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "httpClientRequestTimeOutMilliSecond"));
    /**
     * htpp 请求链接 时长  毫秒
     */
    public static final int HTTP_CONNECT_TIMEOUT = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "httpClientConnectTimeOutMilliSecond"));
    /**
     * htpp 请求响应 时长  毫秒
     */
    public static final int HTTP_SOCKE_TTIMEOUT = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "httpClientSocketTimeOutMilliSecond"));
    /**
     * 导出最多的指标个数
     */
    public static final int METRICS_NUM = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "metricsNum"));
    /**
     * 导出指标的个数
     */
    public static final int METRICS_DATA_SIZE = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "metricsDataSize"));

    /**
     * ThemeMap 域名
     */
    public static final String THEMEMAP_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "themeMap.domain.url");
    public static final String AGILE_DATA_ECHO_DOMAIN = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "agileDataEcho.domain.url");

    public static final String EOC_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "eoc.domain.url");

    public static final String ATHENA_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "athena.domain.url");

    public static final String THEMEMAP_ACTION_MECHANISM_NEW = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/Mechanism/queryVariable";
    public static final String AGILE_DATA_ECHO_URL = AGILE_DATA_ECHO_DOMAIN + "/api/ai/agile/echo/exception/submit";

    public static final String THEMEMAP_ACTION_QUERYEXECUTIONPATH = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/Action/queryExecutionPath";
    public static final String THEMEMAP_ACTION_METRICQUERYSCHEMA = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/metric/metricQuerySchema";

    public static final String THEMEMAP_ACTION_QUERYSMARTDATAVARIABLE = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/Mechanism/querySmartDataVariable";

    public static final String THEMEMAP_ACTION_RULE = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/Action/ActionRule?ruleId=";

    public static final String BPM_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "bpm.domain.url");
    public static final String BPM_START_PROCESS = BPM_DOMAIN_URL + "/standard/bpm_cloud/v1/process-engine/process-instances/invoke-process";

    public static final String BMD_GENERAL_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "bmd.domain.url");
    //    public static final String BMD_GENERAL_API_URL = BMD_GENERAL_URL + "/server/semantic/api/v1/public/common/model/playground";
    public static final String BMD_GENERAL_API_URL = BMD_GENERAL_URL + "/restful/service/dataModel/semantic/modelDataQuery";

    public static final String DCP_GENERAL_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "dcp.domain.url");
    public static final String DCP_GENERAL_API_URL = DCP_GENERAL_URL + "/api/ddl/parse/and/return";

    public static final String THEMEMAP_AP_NAME = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "themeMap.ap.name");

    public static final String THEMEMAP_MODULE_NAME = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "themeMap.moduleName");

    public static final String TASKENGINE_MODULE_NAME = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "taskEngine.moduleName");
    public static final String PTM_MODULE_NAME = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "ptm.moduleName");
    public static final String AUDC_MODULE_NAME = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "audc.moduleName");

    public static final String THEMEMAP_LICENSEKEY_MD5_KEY = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "themeMap.licenseKey.md5.key");

    public static final String THEMEMAP_LICENSEKEY_REQUEST_FROM = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "themeMap.licenseKey.request.from");

    public static final int RESPONSE_SUCCESS_STATUS = 200;
    public static final int DCP_RESPONSE_SUCCESS_STATUS = 0;

    public static final String THEMEMAP_APP_LICENSEKEY = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/app/licenseKey?tenantId=";

    /**
     * 小AI子模块 audc
     */
    public static final String AUDC_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "audc.domain.url");

    /**
     * 任务引擎服务domain
     */
    public static final String TASKENGINE_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "taskEngine.domain.url");
    //ptm地址
    public static final String PTM_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "ptm.domain.url");
    /**
     * 任务引擎接口地址url
     */
    public static final String TASKENGINE_SERVICE_URL = TASKENGINE_DOMAIN_URL + "/standard/taskengine/v1/projects/create-project-instance";

    public static final String SERVICE_COMPOSER_DOMAIN = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "serviceComposer.domain.url");
    public static final String SERVICE_COMPOSER_URL = SERVICE_COMPOSER_DOMAIN + "/service/scdispatcher/execution/dispatch";
    public static final String EE_COMPOSER_DOMAIN = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "ee.domain.url");
    public static final String EE_URL = EE_COMPOSER_DOMAIN + "/restful/service/ExecutionEngine/execute";

    /**
     * moduleName 与域名映射
     */
    public static final Map<String, String> MODULE_DOMAIN_MAP = new HashMap<>();

    static {
        //km
        MODULE_DOMAIN_MAP.put(THEMEMAP_MODULE_NAME, THEMEMAP_DOMAIN_URL);
        //任务引擎
        MODULE_DOMAIN_MAP.put(TASKENGINE_MODULE_NAME, TASKENGINE_DOMAIN_URL);
        //aduc
        MODULE_DOMAIN_MAP.put(AUDC_MODULE_NAME, AUDC_DOMAIN_URL);
        //ptm
        MODULE_DOMAIN_MAP.put(PTM_MODULE_NAME, PTM_DOMAIN_URL);
    }

}