package com.digiwin.athena.executionengine.service.facade.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.bo.DataCenterParamBo;
import com.digiwin.athena.executionengine.dto.DataCenterDto;
import com.digiwin.athena.executionengine.model.DataDescription;

import java.util.Map;

/**
 * @description: schema组装
 * @author: ZhangJun
 * @create: 2024/9/13
 */
public interface ISchemaBuilder {

    /**
     * 组装查询方案
     * 动态替换filter条件
     * 动态调整group 维度
     * 以及始置一些参数的功能
     *
     * @param querySchema     默认查询方案
     * @param reqData
     * @param actionId
     * @param dataDescription
     * @return
     */
    Map<String, Object> buildQuerySchema(JSONObject querySchema, Map<String, Object> reqData, String actionId, DataDescription dataDescription);


    /**
     * 新架构下的查询方案组装
     * 覆盖buildQuerySchema 方法内容
     *
     * @param querySchema
     * @param reqData
     * @param dataDescription
     * @return
     */
    Map<String, Object> buildQuerySchemaByNewStrategy(JSONObject querySchema, Map<String, Object> reqData, DataDescription dataDescription);

    /**
     * 导出明细querySchema
     *
     * @param querySchema
     * @param reqData
     * @param dataDescription
     * @return
     */
    Map<String, Object> buildExportQuerySchema(String querySchema, Map<String, Object> reqData, DataDescription dataDescription);

    /**
     * 组装数据中心的查询方案
     * @param dataDescription
     * @return
     */
    DataCenterParamBo buildDataCenterSchema(DataDescription dataDescription);
}
