package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.NumberRangeRuleElement;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.service.client.impl.ThemeMapClient;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 * @description: 数据逻辑判断新增列
 * @author: zhangww
 * @date: 2021/1/5 9:13
 */
@Component("numberRange")
public class NumberRangeStep extends TransAbstractStep {

    private static final Logger LOGGER = LoggerFactory.getLogger(NumberRangeStep.class);

    private ThemeMapClient themeMapClient;

    @Resource
    public void setThemeMapClient(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        if (StringUtils.isEmpty(stepElement.getNewField()) || StringUtils.isEmpty(stepElement.getColumn())) {
            return false;
        }

        List<NumberRangeRuleElement> rules = stepElement.getRule();
        for (NumberRangeRuleElement rule : rules) {
            //如果是var或者commonvar类型则跳过后续检测
            if (TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getLowerType()) || TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getLowerType()) || TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getLowerType())
                    || TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getUpperType()) || TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getUpperType()) || TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getUpperType())) {
                return true;
            }
            if (TransConstant.NUMBERRANGE_COMPONENT_RIGHTOPENRANGE.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getLower()) ||
                        (StringUtils.isNotEmpty(rule.getUpper()) && !isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper())))) {
                    return false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_LEFTOPENRANGE.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getUpper()) ||
                        (StringUtils.isNotEmpty(rule.getLower()) && !isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper())))) {
                    return false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_CLOSERANGE.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getLower()) || StringUtils.isEmpty(rule.getUpper())) {
                    return false;
                }
                if (!isLessThanOrEqual(new BigDecimal(rule.getLower()), new BigDecimal(rule.getUpper()))) {
                    return false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_OPENRANGE.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getLower()) && StringUtils.isEmpty(rule.getUpper())) {
                    return false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_EQUAL.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getLower())) {
                    return false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_NOTEQUAL.equals(rule.getDecision())) {
                if (StringUtils.isEmpty(rule.getLower())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = getCurrentData(step.getPrevStepNameList());

        if (!(inputData instanceof List)) {
            LOGGER.warn("NumberRangeStep组件只能接受表状数据，非展平数据需要先执行展平节点！Trans执行 {} 失败，数据结构错误！",
                    step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }

        //输入数据
        List<Map<String, Object>> dataList = (List<Map<String, Object>>) inputData;
        // 数据源为空直接返回
        if (CollectionUtils.isEmpty(dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }

        StepElement stepElement = step.getStepElement();
        //遍历规则并赋值
        List<NumberRangeRuleElement> rules = stepElement.getRule();
        for (Map<String, Object> data : dataList) {
            Object column = data.get(stepElement.getColumn());
            String strColumn = String.valueOf(column);
            if ("null".equals(strColumn) || StringUtils.isEmpty(strColumn)) {
                strColumn = "0";
            }
            //将boolean转为0或者1，减少后续修改
            if ("false".equalsIgnoreCase(strColumn) || "true".equalsIgnoreCase(strColumn)) {
                strColumn = "false".equalsIgnoreCase(strColumn) ? "0" : "1";
            }
            //根据规则进行数值范围判断并赋值
            setValueByRule(stepElement, data, rules, new BigDecimal(strColumn));
        }

        dealResult.setSuccess(dataList);
        return dealResult;
    }

    /**
     * 根据规则进行数值范围判断并赋值
     *
     * @param stepElement
     * @param data        源数据
     * @param rules       判断规则
     * @param column      进行逻辑判断的列
     */
    private void setValueByRule(StepElement stepElement, Map<String, Object> data, List<NumberRangeRuleElement> rules, BigDecimal column) {
        //defaultValue允许为空
        String value = stepElement.getDefaultValue();
        if (TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(stepElement.getDefaultValueType())) {
            value = String.valueOf(data.get(stepElement.getDefaultValue()));
        }
        for (NumberRangeRuleElement rule : rules) {
            List<String> commonVarParamList = new ArrayList<>();
            if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getLowerType())) {
                commonVarParamList.add(rule.getLower());
            }
            if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getUpperType())) {
                commonVarParamList.add(rule.getUpper());
            }
            if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getValueType())) {
                commonVarParamList.add(rule.getValue());
            }
            Map<String, Object> commonVarMap = getTransDataManager().getCommonVarCollection();
            if (CollectionUtils.isNotEmpty(commonVarParamList)) {
                //新增commonvar类型逻辑
                JSONObject respData = themeMapClient.querySmartDataVariable(getTransDataManager().getTenantId(), commonVarParamList, getTransDataManager().getToken());
                commonVarMap = commonVarMap == null
                        ? new HashMap<>() : commonVarMap;
                Map<String, Object> finalCommonVarMap = commonVarMap;
                commonVarParamList.forEach(numberRangeItem -> finalCommonVarMap.put(numberRangeItem,
                        Optional.ofNullable(respData).map(item -> item.get(numberRangeItem)).orElse(null))
                );
                getTransDataManager().setCommonVarCollection(commonVarMap);
            }
            BigDecimal lower = null;
            if (StringUtils.isNotEmpty(rule.getLower())
                    && !TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getLowerType())
                    && !TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getLowerType())
                    && !TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getLowerType())) {
                //再判断下lowerDataType是否为boolean,前面的column的值已经从boolean改成了1与0
                lower = new BigDecimal("boolean".equalsIgnoreCase(rule.getLowerDataType()) ?
                        "true".equalsIgnoreCase(rule.getLower()) ? "1" : "0"
                        : rule.getLower());
            } else if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getLowerType())) {
                lower = getCommonVarValue(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(getCommonVarValue(rule.getLower())));
            } else if (TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getLowerType())) {
                lower = getTransDataManager().getMechanismData(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(getTransDataManager().getMechanismData(rule.getLower())));
            } else if (StringUtils.isNotEmpty(rule.getLower()) && TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getLowerType())) {
                lower = data.get(rule.getLower()) == null ? null : new BigDecimal(String.valueOf(data.get(rule.getLower())));
            } else if (TransConstant.SOURCE_TYPE_SYSTEM_VAR.equalsIgnoreCase(rule.getLowerType())) {
                lower = new BigDecimal(getSystemVarValue(rule.getLower()));
            }

            BigDecimal upper = null;
            if (StringUtils.isNotEmpty(rule.getUpper())
                    && !TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getUpperType())
                    && !TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getUpperType())
                    && !TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getUpperType())) {
                //再判断下upperDataType是否为boolean
                upper = new BigDecimal("boolean".equalsIgnoreCase(rule.getUpperDataType()) ?
                        "true".equalsIgnoreCase(rule.getUpper()) ? "1" : "0"
                        : rule.getUpper());
            } else if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getUpperType())) {
                upper = getCommonVarValue(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(getCommonVarValue(rule.getUpper())));
            } else if (TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getUpperType())) {
                upper = getTransDataManager().getMechanismData(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(String.valueOf(getTransDataManager().getMechanismData(rule.getUpper()))));
            } else if (StringUtils.isNotEmpty(rule.getUpper()) && TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getUpperType())) {
                upper = data.get(rule.getUpper()) == null ? null : new BigDecimal(String.valueOf(data.get(rule.getUpper())));
            } else if (TransConstant.SOURCE_TYPE_SYSTEM_VAR.equalsIgnoreCase(rule.getUpperType())) {
                upper = new BigDecimal(getSystemVarValue(rule.getUpper()));
            }


            boolean defaultFlag = true;
            String decision = rule.getDecision();
            if (TransConstant.NUMBERRANGE_COMPONENT_RIGHTOPENRANGE.equals(decision)) {
                if ((upper == null && isGreaterThanOrEqual(lower, column))
                        || (upper != null && isGreaterThanOrEqual(lower, column) && isLessThan(column, upper))) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_LEFTOPENRANGE.equals(decision)) {
                if ((lower == null && isLessThanOrEqual(column, upper))
                        || (lower != null && isGreaterThan(lower, column) && isLessThanOrEqual(column, upper))) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_CLOSERANGE.equals(decision)) {
                if (isGreaterThanOrEqual(lower, column) && isLessThanOrEqual(column, upper)) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_OPENRANGE.equals(decision)) {
                if ((lower == null && isLessThan(column, upper))
                        || (upper == null && lower != null && isGreaterThan(lower, column))
                        || (upper != null && lower != null && isGreaterThan(lower, column) && isLessThan(column, upper))) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_EQUAL.equals(decision)) {
                if (lower != null && isEqual(lower, column)) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            } else if (TransConstant.NUMBERRANGE_COMPONENT_NOTEQUAL.equals(decision)) {
                if (lower != null && isNotEqual(lower, column)) {
                    value = getRangeValue(rule, data);
                    defaultFlag = false;
                }
            }
            if (defaultFlag) {
                if (TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(stepElement.getDefaultValueType())) {
                    data.put(stepElement.getNewField(), data.get(stepElement.getDefaultValue()));
                } else {
                    data.put(stepElement.getNewField(),
                            (TransConstant.SOURCE_TYPE_CONSTANT.equalsIgnoreCase(stepElement.getDefaultValueType())
                                    || StringUtils.isEmpty(stepElement.getDefaultValueType()))
                                    && TransConstant.VALUE_TYPE_NUMBER.equalsIgnoreCase(stepElement.getDefaultValueDataType())
                                    ? new BigDecimal(value) : value);
                }
            } else {
                data.put(stepElement.getNewField(),
                        (TransConstant.SOURCE_TYPE_CONSTANT.equalsIgnoreCase(rule.getValueType())
                                || StringUtils.isEmpty(rule.getValueType()))
                                && TransConstant.VALUE_TYPE_NUMBER.equalsIgnoreCase(rule.getValueDataType())
                                ? new BigDecimal(value) : value);
            }
        }
    }

    /**
     * 获取对应的range值
     *
     * @param rule 规则rule
     * @param data 数据
     * @return 规则对应的值
     */
    private String getRangeValue(NumberRangeRuleElement rule, Map<String, Object> data) {
        if (TransConstant.SOURCE_TYPE_COMMON_VAR.equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(getCommonVarValue(rule.getValue()) == null ? "" : getCommonVarValue(rule.getValue()));
        } else if (TransConstant.SOURCE_TYPE_MECHANISM.equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(getTransDataManager().getMechanismData(rule.getValue()));
        } else if (TransConstant.SOURCE_TYPE_COLUMN.equalsIgnoreCase(rule.getValueType())) {
            return String.valueOf(data.get(rule.getValue()));
        } else if (TransConstant.SOURCE_TYPE_SYSTEM_VAR.equalsIgnoreCase(rule.getValueType())) {
            return getSystemVarValue(rule.getValue());
        } else {
            return rule.getValue();
        }
    }

    /**
     * 是否大于等于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isGreaterThanOrEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && !isLessThan(column, compareValue);
    }

    /**
     * 是否等于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && !isNotEqual(compareValue, column);
    }

    /**
     * 是否不等于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isNotEqual(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && compareValue.compareTo(column) != 0;
    }

    /**
     * 是否小于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isLessThan(BigDecimal column, BigDecimal compareValue) {
        return compareValue != null && column.compareTo(compareValue) < 0;
    }

    /**
     * 是否小于等于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isLessThanOrEqual(BigDecimal column, BigDecimal compareValue) {
        return compareValue != null && !isGreaterThan(compareValue, column);
    }

    /**
     * 是否大于
     *
     * @param compareValue 比较的值
     * @param column       比较列的值
     * @return
     */
    private boolean isGreaterThan(BigDecimal compareValue, BigDecimal column) {
        return compareValue != null && compareValue.compareTo(column) < 0;
    }

    /**
     * 获取业务变量的值
     *
     * @param key
     * @return
     */
    private Object getCommonVarValue(String key) {
        Map<String, Object> commonVarMap = getTransDataManager().getCommonVarCollection();
        if (commonVarMap != null && commonVarMap.get(key) != null) {
            JSONObject commonVar = (JSONObject) commonVarMap.get(key);
            String status = commonVar.getString("status");
            if ("1".equals(status)) {
                return ((JSONObject) commonVarMap.get(key)).get("value");
            }
        }
        return null;
    }

    /**
     * 获取系统业务变量的值
     *
     * @param systemVarName
     * @return
     */
    private String getSystemVarValue(String systemVarName) {
        switch (systemVarName) {
            case "s_runTime":
                return DateUtils.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
            case "s_runDate":
                return DateUtils.getCurrentDateTime("yyyy-MM-dd");
            case "s_userName":
                return getTransDataManager().getLoginUserName();
            case "s_userId":
                return getTransDataManager().getUserId();
        }
        return systemVarName;
    }
}