package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.LogDataDto;
import com.digiwin.athena.executionengine.dto.LogDto;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.MqSendUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @description: 任务引擎action
 * @author: zhangjun
 * @date: 2021/6/15
 */
@Service("DataEventAction")
public class DataEventAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataEventAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String dataEventId = actionParam.getMetaObj().getString(MetaDataConstant.ACTION_DATAEVENT_ID);
        LOGGER.info("上下文取到的locale:{}", context.getLocale());
        String locale = context.getLocale() != null ? context.getLocale() :
                actionParam.getActionJson().getString(MetaDataConstant.ACTION_LOCALE);
        LOGGER.info("发起任务引擎最终使用的locale:{}", locale);
        JSONObject respObj = null;
        try {
            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, context.getRouterKey());

            Map<String, Object> param = new HashMap<>();
            param.put("dataEventId", dataEventId);
            param.put("locale", locale);
            param.put("process_EOC", context.getEocMap());
            param.put("variables", reqMap);

            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.TASKENGINE_SERVICE_URL, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("执行引擎调用任务引擎执行{}:{}返回的结果为：null", actionParam.getActionId(), jsonParam);
                return null;
            }
            LOGGER.info("调用任务引擎执行{}:{}返回的结果为：{}", actionParam.getActionId(), jsonParam, httpRespContent);
            respObj = ServiceResponseUtils.getDataEventResp(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            logTrace(respObj, true);
            MqSendUtils.sendSuccessMessage(context, "TaskEngine", param);
            return respObj;
        } catch (Exception e) {
            logTrace(respObj, false);
            LOGGER.error("调用任务引擎异常", e);
            context.setExecuteStatus(false);
            MqSendUtils.sendExceptionMessage(context, e.getMessage());
            throw e;
        }
    }

    /**
     * 埋点 调用任务引擎
     *
     * @param respObj
     */
    private void logTrace(JSONObject respObj, boolean success) {
        String value = Optional.ofNullable(respObj).map(item -> item.getString("serialNumber")).orElse(null);
        LogDataDto logDataDto = new LogDataDto(value, "任务引擎流程序号", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
        String message = success ? "调用任务引擎成功" : "调用任务引擎失败";
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            LOGGER.info(logDto.toString());
        } else {
            LOGGER.error(logDto.toString());
        }
    }

}
