package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/12 16:43
 */
@Service("FormulaAction")
public class FormulaAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaAction.class);
    private static final String SCRIPT_ENGINE_SHORT_NAME = "nashorn";

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> exprParams, ActionParam actionParam) {
        JSONObject actionJson = actionParam.getActionJson();
        String expression = actionJson.getString(MetaDataConstant.ACTION_EXPRESSION);
        String target = actionJson.getString(MetaDataConstant.ACTION_TARGET);
        if (StringUtils.isEmpty(expression)) {
            LOGGER.warn("执行引擎执行{} Formula {} 没有对应的参数表达式", actionParam.getActionId(), expression);
            context.setExecuteStatus(false);
            return null;
        }
        try {
            //运行表达式脚本并存储计算结果
            Object result = doExpression(expression, exprParams);
            Map<String, Object> returnMap = new HashMap<>();
            returnMap.put(target, result);
            context.setExecuteStatus(true);
            return returnMap;
        } catch (Exception e) {
            LOGGER.error("执行引擎Formula[{}]执行表达式异常:{}", actionParam.getActionId(), e);
            context.setExecuteStatus(false);
            throw new BusinessException(ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getCode(),
                    ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getMessage(), e);
        }
    }


    /**
     * Script 表达式计算
     *
     * @param expression
     * @param exprParams
     * @return
     * @throws Exception
     */
    public Object doExpression(String expression, Map<String, Object> exprParams) throws Exception {

        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(SCRIPT_ENGINE_SHORT_NAME);
        ScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(engine.createBindings(), ScriptContext.ENGINE_SCOPE);

        String runExpr = expression;
        //根据参数名称替换表达式中的 参数值
        if (MapUtils.isNotEmpty(exprParams)) {
            for (Map.Entry<String, Object> params : exprParams.entrySet()) {
                runExpr = runExpr.replace(params.getKey(), String.valueOf(params.getValue()));
            }
        }
        //返回表达式计算结果
        return engine.eval(runExpr, ctx);
    }


}
