package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2023/1/11
 */
@Service("ThirdPartyAction")
public class ThirdPartyAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyAction.class);

    private static final String URL = "url";
    private static final String METHOD = "method";

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String url = actionParam.getMetaObj().getString(URL);
        String method = actionParam.getMetaObj().getString(METHOD);
        try {
            Map<String, String> headerMap = new HashMap<>(1);
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            String httpRespContent = HttpClientUtils.doRequest(method, url, headerMap, reqMap);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("调用第三方API{}:{}返回的结果为：null", actionParam.getActionId(), JSON.toJSONString(reqMap));
                return null;
            }
            LOGGER.info("调用第三方API{}:{}返回的结果为：{}", actionParam.getActionId(), JSON.toJSONString(reqMap), httpRespContent);
            JSONObject respObj = JSONObject.parseObject(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            return respObj;
        } catch (Exception e) {
            LOGGER.error("调用第三方API错误", e);
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0006");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.THIRD_PARTY);
            context.setExecuteErrorMessage(executeErrorMessage);
            throw e;
        }
    }
}
