package com.digiwin.athena.executionengine.core.aop;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.runinfo.ActionExecutionDto;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/4/15
 */
@Aspect
@Component("engineDebugAspect")
public class DebugAspect {
    @Pointcut("@annotation(com.digiwin.athena.executionengine.core.aop.Debug)")
    public void pointcut() {
    }


    @Around("pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Debug debug = method.getAnnotation(Debug.class);
        if (debug == null) {
            //没有标注debug注解，直接执行
            return joinPoint.proceed();
        }

        Object[] args = joinPoint.getArgs();
        ExecuteContext context = (ExecuteContext) args[0];
        if (!context.isDebug()) {
            return joinPoint.proceed();
        }

        ActionParam actionParam = (ActionParam) args[2];
        JSONObject metaObj = actionParam.getMetaObj();
        String actionTypeDescription = metaObj.getString("actionTypeDescription");
        String actionName = metaObj.getString("actionName");
        String actionId = actionParam.getActionId();

        int recordCnt = 0;
        Object proceed = joinPoint.proceed();
        if (proceed != null && proceed instanceof List) {
            recordCnt = ((List) proceed).size();
        } else if (proceed instanceof Map) {
            Object data = ((Map) proceed).get("data");
            if(data != null && data instanceof List){
                recordCnt = ((List) data).size();
            }
        }

        /**
         * todo 如果是指标action 需要额外处理下
         *
         * 另外 bmd和 sql 需要记录sql数据
         */
        ActionExecutionDto actionExecutionDto = new ActionExecutionDto(actionId, recordCnt, actionTypeDescription, actionName);
        actionExecutionDto.setQuery(context.getQuerySqlMap().get(actionId));
        context.getRunInfo().getActionExecutionDtos().add(actionExecutionDto);
        return proceed;
    }
}
