package com.digiwin.athena.executionengine.core.holder;

import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;

import java.util.Arrays;
import java.util.List;

public class RecordTableNameHandler implements TableNameHandler {

    /**
     * 每个请求线程维护一个month的数据
     */
    private static final ThreadLocal<String> MONTH_DATA = new ThreadLocal<>();
    /**
     * 记录哪些表需要分表
     */
    private List<String> tableNames;

    public RecordTableNameHandler(String ...tableNames) {
        this.tableNames = Arrays.asList(tableNames);
    }

    public static void setData(String month){
        MONTH_DATA.set(month);
    }

    public static void removeData(){
        MONTH_DATA.remove();
    }

    @Override
    public String dynamicTableName(String sql, String tableName) {
      if(this.tableNames.contains(tableName)){
          //表名加上月份后缀  例如：tableName2024_01
          return tableName + MONTH_DATA.get();
      }else {
          return tableName;
      }
    }
}
