package com.digiwin.athena.executionengine.dto;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.executionengine.constant.LogConstant;

import java.util.List;

/**
 * @description: 一站式排查 日志埋点
 * @author: ZhangJun
 * @create: 2023/8/21
 */
public class LogDto {
    private String message;
    private String key = LogConstant.DEFAULT_KEY;
    private List<LogDataDto> data;

    public LogDto() {
    }

    public LogDto(String message, List<LogDataDto> data) {
        this.message = message;
        this.data = data;
    }

    public LogDto(String message, String key) {
        this.message = message;
        this.key = LogConstant.SOURCE_KEY + ";" + key;
    }

    public LogDto(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<LogDataDto> getData() {
        return data;
    }

    public void setData(List<LogDataDto> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
