package com.digiwin.athena.executionengine.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;

/**
 * @description: 自定义异常类
 * @author: dongwh
 * @date: 2021/2/5 11:21
 */
public class CustomException extends DWRuntimeException {

    /**错误编码*/
    private String errorCode;

    @Override
    public String getErrorType() {
        return "application";
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public CustomException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误编码
     * @param message   信息描述
     */
    public CustomException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public CustomException(String errorCode, String message, String... messageArgs) {
        super(errorCode, message, messageArgs);
    }


    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误编码
     * @param message   信息描述
     */
    public CustomException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }


    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public CustomException(String message, Throwable cause) {
        super(message, cause);
    }

}
