package com.digiwin.athena.executionengine.model.input;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/6/4
 */
public class SolutionStepInput {

    private String tenantId;
    private List<Map<String, Object>> eocMaps;
    private Map<String, Object> sysParam;
    private JSONArray solutionStep;

    private Map<String, Object> permissions;

    private JSONObject extension;

    public SolutionStepInput(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, Map<String, Object> permissions) {
        this.tenantId = tenantId;
        this.eocMaps = eocMaps;
        this.sysParam = sysParam;
        this.solutionStep = solutionStep;
        this.permissions = permissions;
    }

    public SolutionStepInput(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, JSONObject extension) {
        this.tenantId = tenantId;
        this.eocMaps = eocMaps;
        this.sysParam = sysParam;
        this.solutionStep = solutionStep;
        this.extension = extension;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<Map<String, Object>> getEocMaps() {
        return eocMaps;
    }

    public void setEocMap(List<Map<String, Object>> eocMaps) {
        this.eocMaps = eocMaps;
    }

    public Map<String, Object> getSysParam() {
        return sysParam;
    }

    public void setSysParam(Map<String, Object> sysParam) {
        this.sysParam = sysParam;
    }

    public JSONArray getSolutionStep() {
        return solutionStep;
    }

    public void setSolutionStep(JSONArray solutionStep) {
        this.solutionStep = solutionStep;
    }

    public Map<String, Object> getPermissions() {
        return permissions;
    }

    public void setPermissions(Map<String, Object> permissions) {
        this.permissions = permissions;
    }

    public JSONObject getExtension() {
        return extension;
    }

    public void setExtension(JSONObject extension) {
        this.extension = extension;
    }
}
