package com.digiwin.athena.executionengine.model.trans;

import java.util.List;

import static com.digiwin.athena.executionengine.constant.CommonConstant.STRING_THIRTY_TWO;
import static com.digiwin.athena.executionengine.constant.TransConstant.ROUNDING;

/**
 * @description: 分组条件
 * @author: xijj
 * @date: 2020/7/21 10:16
 */
public class Statistic {

    private String statisticalMethod;

    private List<String> statisticalFields;

    private String newField;

    private String type;
    /**
     * 排序用到的模式
     */
    private String mode;

    /**
     * limit用到的取值方向
     */
    private String direction;
    /**
     * limit取值的起始位置
     * 当irr算法时，作为搜索区间的上界，不填默认为 -1
     */
    private String startPos;
    /**
     * limit取值的结束位置
     * 当irr算法时，作为搜索区间的下界，不填默认为 1
     */
    private String endPos;

    /**
     * 自定义排序字段名称
     */
    private String sortName;

    /**
     * 计算精度，超过精度的部分做截断处理
     * 允许不传，不传时默认32位精度
     */
    private String precision = STRING_THIRTY_TWO;

    /**
     * 取整类型
     * 向上取整、向下取整、四舍五入、向上舍入、向下舍入 对应的配置分别为（ceil、floor、rounding、round_up、round_down）
     * 允许不传，不传默认rounding
     */
    private String precisionType = ROUNDING;

    /**
     * 数据运算逻辑异常的做法
     * divideDefault：计算除法当分母为0时，分子为0则输出0，否则输出1
     * dividedZeroToZero：计算除法当分母为0时，输出为0
     */
    private String exceptionHandling;

    /**
     * 目前使用场景：irr计算
     * 最大迭代次数，默认100
     */
    private String maximumIterations;

    /**
     * 目前使用场景：npv计算
     * 利率
     */
    private String rate;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatisticalMethod() {
        return statisticalMethod;
    }

    public void setStatisticalMethod(String statisticalMethod) {
        this.statisticalMethod = statisticalMethod;
    }

    public List<String> getStatisticalFields() {
        return statisticalFields;
    }

    public void setStatisticalFields(List<String> statisticalFields) {
        this.statisticalFields = statisticalFields;
    }

    public String getNewField() {
        return newField;
    }

    public void setNewField(String newField) {
        this.newField = newField;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getStartPos() {
        return startPos;
    }

    public void setStartPos(String startPos) {
        this.startPos = startPos;
    }

    public String getEndPos() {
        return endPos;
    }

    public void setEndPos(String endPos) {
        this.endPos = endPos;
    }

    public String getPrecisionType() {
        return precisionType;
    }

    public void setPrecisionType(String precisionType) {
        this.precisionType = precisionType;
    }

    public String getPrecision() {
        return precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getExceptionHandling() {
        return exceptionHandling;
    }

    public void setExceptionHandling(String exceptionHandling) {
        this.exceptionHandling = exceptionHandling;
    }

    public String getMaximumIterations() {
        return maximumIterations;
    }

    public void setMaximumIterations(String maximumIterations) {
        this.maximumIterations = maximumIterations;
    }

    public String getRate() {
        return rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }
}