package com.digiwin.athena.executionengine.mq.consumer;

import com.digiwin.athena.executionengine.constant.MqConstant;
import com.rabbitmq.client.Channel;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/7/6
 */
@Component("engineSCCallBackConsumer")
public class SCCallBackConsumer {
    @RabbitListener(queuesToDeclare = @Queue(MqConstant.SC_MQ_QUEUE))
    public void consumeMessage(Message message, Channel channel) throws IOException {
        channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
    }
}
