package com.digiwin.athena.executionengine.mq.producer;

import com.digiwin.athena.executionengine.constant.MqConstant;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/12/15
 */
@Component
public class RabbitMqProducer {
    @Autowired
    @Qualifier("engineRabbitTemplate")
    private RabbitTemplate template;

    public void sendMessage(Object message, String routerKey) {
        template.convertAndSend(MqConstant.LOG_MQ_EXCHANGE, routerKey, message);
    }
}
