package com.digiwin.athena.executionengine.provider;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.smartdata.sdk.DatasourceProxyInitialize;
import com.digiwin.athena.smartdata.sdk.EspProxyInitialize;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @description:
 * @author: dongwh
 * @date: 2020/8/20 15:10
 */
public class ExecutionEngineApplication implements IExecutionEngineApplication {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionEngineApplication.class);

    @Override
    public Object appLicationMain() {

        //加载esp-proxy sdk的配置，调用sdk方法进行初始化
        String rabbitMqUri = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "esp.sdk.rabbit.mq.uri");
        String espDomain = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "esp.sdk.esp.domain");
        String mdcDomain = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "esp.sdk.mdc.domain");
        String tmDomain = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "esp.sdk.tm.domain");
        String eocDomain = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "esp.sdk.eoc.domain");

        EspProxyInitialize.initConfig(rabbitMqUri, espDomain, mdcDomain, tmDomain, eocDomain);
        DatasourceProxyInitialize.initConfig("cn_test", ModuleProperty.BMD_GENERAL_URL,ModuleProperty.DCP_GENERAL_URL);

        // 获取ip地址
        System.setProperty("ip", IpUtils.getIp());
        LOGGER.info("----------------------------------------------------");
        LOGGER.info("-------------ExecutionEngineApplication-------------");
        LOGGER.info("--------------------执行引擎启动成功-------------------");
        LOGGER.info("-------------ExecutionEngineApplication-------------");
        LOGGER.info("----------------{}------------------", DateUtils.getCurrentDateTime());
        LOGGER.info("----------------------------------------------------");
        return null;
    }
}
