package com.digiwin.athena.executionengine.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.constant.AgileDataErrorCodeConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/6/16
 */
@Service("engineTransService")
public class TransService implements ITransService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransService.class);

    @Autowired
    private ITransSrp transSrp;

    @Autowired
    private IExecutionFacade executeFacade;

    @Override
    public Object postRunTrans(String tenantId, String ruleId, Map<String, Object> param) {
        ServiceResult serviceResult = transSrp.runTrans(tenantId, ruleId, param, null);
        return serviceResult.getData();
    }

    @Override
    public Object postRunTrans(List<Map<String, Object>> recasts, Object data, String tenantId) {
        JSONObject json = new JSONObject(3);
        json.put("tenantId", tenantId);
        json.put("recasts", recasts);
        json.put("data", data);
        String source = (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SOURCE);
        LOGGER.info(String.format("二次计算入参:%s", JSONObject.toJSONString(json)));
        if (StringUtils.isNotEmpty(source)) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "二次计算入参:%s", source, JSONObject.toJSONString(recasts)));
        }
        ServiceResult serviceResult = transSrp.runTrans(tenantId, recasts, data);
        if (serviceResult.getData() != null && serviceResult.getData() instanceof List) {
            if (CollectionUtils.isEmpty((List) serviceResult.getData())) {
                ErrorLog errorLog = new ErrorLog();
                errorLog.setErrorCode(AgileDataErrorCodeConstant.AGILE_CALCULATE_ERROR_CODE);
                errorLog.setErrorLocation("数据拉取二次计算");
                errorLog.setErrorDescription("二次计算条件过滤后，无符合条件的数据");
                errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
                errorLog.setErrorMessage("[拉取到的数据]以及[二次过滤条件]");
                errorLog.setPossibleCausesAndGuidance("过滤条件设定不正确或者数据库不存在相关的数据");
                LogUtils.buildAgileLog(LogConstant.AGILE_CODE_RECAST, LogUtils.WARING, "二次计算入参：" + JSONObject.toJSONString(recasts), "二次计算条件过滤后，无符合条件的数据，可能是1.真的没有符合过滤条件的数据。2.数据流中join步骤数据不正常", "1.打开场景配置界面，找到场景中的过滤配置。\n" +
                        "2.检查过滤条件，确认其逻辑运算符、比较值等是否正确。\n" +
                        "3.调整过滤设置，保存并重新发版。\n" +
                        "4.去地端执行SQL检查数据的格式是否一致\n" +
                        "5.若问题未解决，联系平台技术支持人员并提供场景code。");
                LOGGER.error(String.format(LogConstant.AGILE_DATA + "二次计算出参:%s", source, errorLog.toString()));
                throw new BusinessException(errorLog.getErrorCode(), errorLog.toString());
            }
        } else {
            serviceResult.setData(new ArrayList<>());
        }
        if (StringUtils.isNotEmpty(source)) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "二次计算出参:%s", source, JSONObject.toJSONString(serviceResult.getData())));
        }
        //executeFacade.generateMetaHandler(new DataMappingManager(data), actionId, tenantId);
        return serviceResult.getData();
    }

    public Object postRunTrans(List<Map<String, Object>> recasts, Object data, String actionId, String tenantId) {
        Object obj = postRunTrans(recasts, data, tenantId);
        Object meta = executeFacade.generateMetaHandler(new DataMappingManager(obj), actionId, tenantId);
        JSONObject result = new JSONObject();
        result.put("meta", meta);
        result.put("data", obj);
        return result;
    }
}
