package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.*;
import com.digiwin.athena.executionengine.service.facade.analyzer.IDataValueExtractor;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("filterStep")
public class FilterSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSolutionStepAnalyzer.class);

    @Autowired
    private IDataValueExtractor dataValueExtractor;

    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object filterData = SolutionStepExecutionFacade.getTransDataMap() != null
                && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey)
                ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("filterStep开始执行filter==null:{}", filterData == null ? "true" : "false");
        if (filterData != null) {
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", "filter");
            Filter newFilter = new Filter();
            Filter filter = solutionStep.getFilter();
            newFilter.setLogic(filter.getLogic());
            JSONArray dataArray = JSONArray.parseArray(JSON.toJSONString(filterData));
            if (CollectionUtils.isEmpty(dataArray)) {
                return;
            }
            JSONObject data = dataArray.getJSONObject(0);
            Set<String> dataFieldKeys = data.keySet();
            //获取查询的字段，用于后续判断filter的条件是否要进行二次过滤判断，因为指标的过滤可以带入指标取数
            // 但是有的步骤不是指标取数，需要进行二次过滤
            List<String> selectedFieldKeys =
                    solutionStep.getSelect().stream().filter(select -> select.getDataObject() != null)
                            .map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
            Set<String> fieldKeys = new HashSet<>(selectedFieldKeys);
            List<FilterHavingChildren> newChildren = dealChildren(filter.getChildren(), solutionStep.getComputeList(), fieldKeys, dataFieldKeys, context, dataKey, stepIndex, solutionStep.getDatasetObject().getAlias(), data);
            if (CollectionUtils.isNotEmpty(newChildren)) {
                newFilter.setChildren(newChildren);
                criteriaDefinition.put("schema", JSONObject.parseObject(JSONObject.toJSONString(newFilter)));
                JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("filterStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
                //重新取下数据，避免计算影响数据source = "DATA_PULLING_2287G575"
                filterData = SolutionStepExecutionFacade.getTransDataMap() != null
                        && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey)
                        ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
                if (filterData != null) {
                    Map<String, Object> dataMap = new HashMap<>();
                    dataMap.put(dataKey, filterData);
                    TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                    TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
                    Object resultData = transEngine.runEngine(transDataManger);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                    LogUtils.buildAgileLog(LogConstant.AGILE_CODE_FILTER_DATA, LogUtils.SUCCESS,
                            String.format("filterData过滤前数据条目数:%s,过滤条件:%s", (JSONArray.parseArray(JSONObject.toJSONString(filterData)).size()), JSONObject.toJSONString(newFilter)),
                            String.format("filterData过滤后数据条目数:%s", resultData == null ? "null" : (JSONArray.parseArray(JSONObject.toJSONString(resultData)).size())),
                            "");
                }
            }
            ISolutionStepAnalyzer selectStep = ContextUtils.getBean("selectStep");
            selectStep.executeStep(solutionStep, stepIndex, context);
        }
    }

    /**
     * 处理过滤的children
     *
     * @param children
     * @param computeList
     * @param fieldKeys     需要查询返回的key
     * @param dataFieldKeys 数据有的key
     * @param context
     * @param dataKey
     * @param stepIndex
     * @param alias
     * @param data          过滤数据的第一条数据
     * @return
     */
    private List<FilterHavingChildren> dealChildren(List<FilterHavingChildren> children, JSONObject computeList, Set<String> fieldKeys, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey, int stepIndex, String alias, JSONObject data) {
        List<FilterHavingChildren> newChildren = new ArrayList<>();
        if (CollectionUtils.isEmpty(children)) {
            return newChildren;
        }
        for (FilterHavingChildren filterHavingChildren : children) {
            FilterHavingChildren newChild = new FilterHavingChildren();
            newChild.setOperator(filterHavingChildren.getOperator());
            newChild.setLogic(filterHavingChildren.getLogic());
            //处理左字段
            BaseObject leftObject = createCalculateBaseObject(filterHavingChildren.getLeft(), filterHavingChildren.getLeft(), computeList, fieldKeys, dataFieldKeys, context, dataKey, data);
            if (leftObject != null) {
                newChild.setLeft(leftObject);
            }
            //处理右字段
            List<FilterHavingChildrenRight> newRightList = new ArrayList<>();
            List<FilterHavingChildrenRight> rightList = filterHavingChildren.getRight();
            if (CollectionUtils.isNotEmpty(rightList)) {
                for (FilterHavingChildrenRight filterHavingChildrenRight : rightList) {
                    FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                    if (filterHavingChildrenRight.getDataObject() != null) {
                        BaseObject rightObject = createCalculateBaseObject(filterHavingChildrenRight.getDataObject(), filterHavingChildren.getLeft(), computeList, fieldKeys, dataFieldKeys, context, dataKey, data);
                        if (rightObject != null) {
                            newChildRight.setDataObject(rightObject);
                        } else {
                            newChildRight = null;
                        }
                    } else {
                        //如果是数据集
                        DatasetObject datasetObject = filterHavingChildrenRight.getDatasetObject();
                        Object rightData = null;
                        if ("metric".equals(datasetObject.getDatasetType())) {
                            rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                        } else if ("step".equals(datasetObject.getDatasetType())) {
                            Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                            if (dataMap.containsKey(datasetObject.getStep())) {
                                rightData = dataMap.get(datasetObject.getStep());
                                rightData = dataValueExtractor.extract(datasetObject.getContent(), filterHavingChildren.getOperator(), rightData);
                            }
                        } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                            //调用上一步骤，递归执行
                            DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = ContextUtils.getBean("datasetObjectStep");
                            datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                            Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                            String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                            if (dataMap.containsKey(key)) {
                                rightData = dataMap.get(key);
                            }
                        }

                        if ("in".equals(filterHavingChildren.getOperator()) || "nin".equals(filterHavingChildren.getOperator())) {
                            String rightStr = (String) rightData;
                             if (StringUtils.isNotEmpty(rightStr)) {
                                String[] split = rightStr.split(",");
                                for (String s : split) {
                                    FilterHavingChildrenRight inChildRight = new FilterHavingChildrenRight();
                                    BaseObject newBaseObject = new BaseObject();
                                    newBaseObject.setContentType("const");
                                    newBaseObject.setDataType("string");
                                    newBaseObject.setContent(s);
                                    inChildRight.setDataObject(newBaseObject);
                                    newRightList.add(inChildRight);
                                }
                            }
                        } else {
                            BaseObject newBaseObject = new BaseObject();
                            newBaseObject.setContentType("const");
                            newBaseObject.setDataType("string");
                            newBaseObject.setContent((String) rightData);
                            newChildRight.setDataObject(newBaseObject);
                            newRightList.add(newChildRight);
                        }

                    }
                }
            }
            if (CollectionUtils.isNotEmpty(newRightList)) {
                newChild.setRight(newRightList);
            }
            //递归处理children
            List<FilterHavingChildren> childChildren = dealChildren(filterHavingChildren.getChildren(), computeList, fieldKeys, dataFieldKeys, context, dataKey, stepIndex, alias, data);
            if (CollectionUtils.isNotEmpty(childChildren)) {
                newChild.setChildren(childChildren);
            }
            if (newChild.getLeft() != null && CollectionUtils.isNotEmpty(newChild.getRight())) {
                newChildren.add(newChild);
            }
        }
        return newChildren;
    }

    /**
     * 生成对应的BaseObject--需要进行判断--避免二次过滤
     *
     * @param baseObject     原始的
     * @param leftBaseObject 左表数据
     * @param computeList    计算信息
     * @param fieldKeys      需要查出的字段
     * @param dataFieldKeys  数据中的字段
     * @param context        基础信息
     * @param dataKey        dataKey
     * @return newBaseObject
     */
    private BaseObject createCalculateBaseObject(BaseObject baseObject, BaseObject leftBaseObject, JSONObject computeList, Set<String> fieldKeys, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey, JSONObject data) {
        //暂不开启日期格式的二次过滤
        if (baseObject == null || "datetime".equals(baseObject.getDataType())
                || "datetime".equals(leftBaseObject.getDataType())) {
            return null;
        }
        BaseObject newBaseObject = new BaseObject();
        if ("calculate".equals(baseObject.getContentType())) {
            //左字段为计算类型
            newBaseObject = doCalculate(baseObject, computeList, dataFieldKeys, context, dataKey);
            return newBaseObject;
        } else if ("const".equals(baseObject.getContentType())) {
            //常量也不再次过滤，这种在取指标的时候一定带过去了，在后续步骤中也不会存在，因为常量会直接带到指标取数中
            //但是如果字段在查询中，可以带进去直接查**** 由于trans做不了datetime的过滤所以也不要带****
            if (!fieldKeys.contains(leftBaseObject.getContent())) {
                //再判断下数据字段中是否有这个值
                if (dataFieldKeys.contains(leftBaseObject.getContent())) {
                    //如果查询字段有这个字段，需要再判断下查询中的字段是否有由这个字段计算得来的
                    //避免虽然存在这个字段，但是由于是聚合操作，全是default
                    for (String fieldKey : fieldKeys) {
                        JSONArray computeArray = computeList == null ? null : computeList.getJSONArray(fieldKey);
                        if (computeArray != null && computeArray.toString().contains("\"content\":\"" + leftBaseObject.getContent() + "\"")) {
                            BeanUtils.copyProperties(baseObject, newBaseObject);
                            return newBaseObject;
                        }
                    }
                    //兜底处理，如果字段是指标中的计算节点算出来的，这时候过滤条件可能不会生效，需要再做一次
                    //这个时候需要判断下这个字段是否是default，不是可以过滤，只判断第一条记录，减少性能损耗
                    //<最优解是拿到KM的指标配置数据进行判断是否需要二次过滤>---改动较大
                    String dataInfo = data.getString(leftBaseObject.getContent());
                    if (!"default".equals(dataInfo)) {
                        BeanUtils.copyProperties(baseObject, newBaseObject);
                        return newBaseObject;
                    }
                }
                return null;
            } else {
                //支持日期类型进行二次过滤，需要将datetime转为trans的date
                if ("datetime".equals(baseObject.getDataType())
                        || "datetime".equals(leftBaseObject.getDataType())) {
                    BeanUtils.copyProperties(baseObject, newBaseObject);
                    newBaseObject.setDataType("date");
                    return newBaseObject;
                }
            }
        }
        BeanUtils.copyProperties(baseObject, newBaseObject);
        return newBaseObject;
    }

    /**
     * 对计算列进行计算操作，返回执行完计算后的baseObject,同时更新结果数据
     *
     * @param baseObject
     * @param computeList
     * @param dataFieldKeys 数据中的字段
     * @param context
     * @param dataKey
     * @return
     */
    private BaseObject doCalculate(BaseObject baseObject, JSONObject computeList, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey) {
        BaseObject newObject = new BaseObject();
        if (!"calculate".equals(baseObject.getContentType())) {
            return baseObject;
        }
        String computeName = baseObject.getContent();
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); i++) {
            //判断运算的字段是否还在
            JSONObject compute = computeJsonArray.getJSONObject(i);
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); j++) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (!dataFieldKeys.contains(parameter.getString("content")) && "field".equals(parameter.getString("contentType"))) {
                    //没有这个字段
                    flag = true;
                    LOGGER.info("filterStep执行doCalculate.trans中计算列不存在于数据集中:{}", parameter.toJSONString());
                }
            }
            if (!flag) {
                newComputeJsonArray.add(compute);
            }
        }
        JSONObject schema = new JSONObject();
        schema.put("rule", newComputeJsonArray);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", "calculate");
        criteriaDefinition.put("schema", schema);
        JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("filterStep执行doCalculate.trans入参:{}", JSONObject.toJSONString(jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, SolutionStepExecutionFacade.getTransDataMap().get(dataKey), context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        Object calculateResult = transEngine.runEngine(transDataManger);
        if (calculateResult == null) {
            LOGGER.info("filterStep执行doCalculate.trans出参为null");
            return baseObject;
        }
        JSONObject lastCalculateFunction = computeJsonArray.getJSONObject(computeJsonArray.size() - 1);
        newObject.setContent(lastCalculateFunction.getString("newField"));
        newObject.setSource(baseObject.getSource());
        newObject.setContentType("field");
        newObject.setDataType(lastCalculateFunction.getString("valueType"));
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newObject;
    }
}
