package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("limitStep")
public class LimitSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(LimitSolutionStepAnalyzer.class);

    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object sortData = SolutionStepExecutionFacade.getTransDataMap() != null
                && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey)
                ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("limitStep开始执行sortData==null:{}", sortData == null ? "true" : "false");
        if (sortData != null) {
            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put(dataKey, sortData);
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", "limit");
            criteriaDefinition.put("schema", JSONObject.parseObject(JSONObject.toJSONString(solutionStep.getLimit())));
            JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
            LOGGER.info("limitStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
            Object resultData = transEngine.runEngine(transDataManger);
            SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
            if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = ContextUtils.getBean("unionStep");
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), resultData);
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }
}
