package com.digiwin.athena.executionengine.service.facade.complement.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.executionengine.model.DataItem;
import com.digiwin.athena.executionengine.model.IncrementalDefinition;
import com.digiwin.athena.executionengine.service.facade.complement.IDataComplement;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/1/24
 */
@Service("dataComplement")
public class DataComplement implements IDataComplement {

    @Override
    public void replenish(IncrementalDefinition incrementalDefinition, Object valueMap, List<Map<String, Object>> apiParams) {
        Map<String, Object> dataMap = (Map<String, Object>) valueMap;
        Object data = dataMap.get("data");
        if (!(data instanceof List)) {
            return;
        }
        //先看数据要补齐字段的格式
        String dateFormat = incrementalDefinition.getGranularity();
        //计算区间
        Set<String> timeList = calTimeList(incrementalDefinition.getIncrease(), dateFormat, apiParams);
        //分析数据结构，如果没有数据，可能需要从action response进行分析
        List<Object> dataList = (List<Object>) data;
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        JSONArray dataArray = (JSONArray) JSON.toJSON(dataList);
        List<String> missingDates = findMissingMonths(dataArray, timeList, incrementalDefinition.getMissingField());
        List<DataItem> dataItems = analyseMetaData(dataArray);
        List<Map> completedData = JsonUtil.getList(JsonUtil.getJsonString(dataList), Map.class);
        missingDates.forEach(item -> {
            Map<String, Object> map = new HashMap<>();
            //补全其他数据
            dataItems.forEach(dataItem -> {
                map.put(dataItem.getName(), getValue(dataItem.getType()));
            });
            //补全月份
            map.put(incrementalDefinition.getMissingField(), item);
            completedData.add(map);
        });
        //对补全的数据进行月份排序
        completedData.sort(Comparator.comparing(item -> (String) ((Map<String, Object>) item).get(incrementalDefinition.getMissingField())));
        dataMap.put("data", completedData);
    }

    private Object getValue(String type) {
        if ("string".equalsIgnoreCase(type)) {
            return "";
        } else if ("number".equalsIgnoreCase(type)) {
            return 0;
        } else {
            return "";
        }
    }

    /**
     * 寻找缺失的
     *
     * @param dataList
     * @param timeList
     * @param missingField
     * @return
     */
    private List<String> findMissingMonths(List<Object> dataList, Set<String> timeList, String missingField) {
        Set<String> srcDateSet = new HashSet<>();
        dataList.forEach(item -> srcDateSet.add((String) ((Map) item).get(missingField)));
        return timeList.stream().filter(item -> !srcDateSet.contains(item)).collect(Collectors.toList());
    }

    private List<DataItem> analyseMetaData(List<Object> dataList) {
        Map<String, Object> map = (Map<String, Object>) dataList.get(0);
        List<DataItem> dataItems = new ArrayList<>();
        map.forEach((k, v) -> {
            dataItems.add(new DataItem(k, getType(v)));
        });
        return dataItems;

    }

    private String getType(Object v) {
        if (v instanceof Number) {
            return "number";
        } else {
            return "string";
        }
    }

    /**
     * 计算时间区间
     *
     * @param increase
     * @param dateFormat
     * @param apiParams
     * @return
     */
    private Set<String> calTimeList(String increase, String dateFormat, List<Map<String, Object>> apiParams) {
        Map<String, Object> inputParam = apiParams.get(0);
        String date = (String) inputParam.get(increase);
        String[] times = date.split("#");
        return DateUtils.getTimeListByBetweenTime(times[0], times[1], dateFormat);
    }
}
