package com.digiwin.athena.executionengine.service.facade.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.PocContext;
import com.digiwin.athena.executionengine.model.step.IStep;
import com.digiwin.athena.executionengine.model.step.MictransStep;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/6/14
 */
@Service("micTrans")
public class MictransConvertor implements IDefinitionConvertor {

    private static final Logger LOGGER = LoggerFactory.getLogger(MictransConvertor.class);

    @Autowired
    private ITransSchemaCreator transSchemaCreator;

    @Override
    public void convert(IStep step, PocContext pocContext) {
        MictransStep stepInfo = (MictransStep) step;
        JSONObject microTransSchema = createTransSchema(stepInfo.getMicroTrans());
        pocContext.getDefine().put(stepInfo.getStep(), microTransSchema);
    }


    private JSONObject createTransSchema(JSONArray microTrans) {
        JSONObject micTrans = microTrans.getJSONObject(0);
        String template = transSchemaCreator.createTransSchemaByTemplate(micTrans);
        try {
            return JSONObject.parseObject(ReplaceUtils.replace(micTrans, template));
        } catch (Exception e) {
            LOGGER.error("micTrans定义转换失败,micTrans:{},template:{}", micTrans, template, e);
            throw e;
        }
    }
}