package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.exception.CustomException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.digiwin.athena.executionengine.constant.TransConstant.CALCULATE_METHOD;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/29
 */
@Service
public class CalculateTransformer implements ICriteriaTransformer {

    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", "calculate");
        JSONArray rule = schema.getJSONArray("rule");

        boolean match = rule.stream().allMatch(obj -> CALCULATE_METHOD.contains(((JSONObject) obj).getString("calFunction").toUpperCase()));
        if (!match) {
            throw new CustomException("存在不支持的计算方法rule:" + rule);
        }

        List<JSONObject> calRules = new ArrayList<>(rule.size());

        rule.forEach(obj -> {
            JSONObject ruleObj = (JSONObject) obj;
            String method = ruleObj.getString("calFunction");
            calRules.add(genCalRule(method, ruleObj));
        });
        variable.put("rule", calRules);
        return variable;
    }

    private JSONObject genCalRule(String method, JSONObject ruleObj) {
        switch (method) {
            case "Add":
            case "Minus":
            case "Multiply":
                return genCommonRule(ruleObj);
            case "Divide":
                JSONObject rule = genCommonRule(ruleObj);
                rule.put("precision", 6);
                return rule;
            case "Abs":
                return genAbsRule(ruleObj);
            case "DateFormat":
                return genDateFormatRule(ruleObj);
            case "GrowthRate":
                return genGrowthRateRule(ruleObj);
            default:
                return null;
        }
    }

    private JSONObject genGrowthRateRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", method);
        rule.put("fieldA", param.getJSONObject(0).getString("content"));
        rule.put("fieldB", param.getJSONObject(1).getString("content"));
        rule.put("fieldA_type", TransConstant.SOURCE_TYPE_COLUMN);
        rule.put("fieldB_type", TransConstant.SOURCE_TYPE_COLUMN);
        rule.put("newField", newField);
        rule.put("valueType", valueType);
        rule.put("retain", true);
        return rule;
    }

    private JSONObject genDateFormatRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", method);
        rule.put("fieldA", param.getJSONObject(0).getString("content"));
        rule.put("formatA", param.getJSONObject(1).getString("content"));
        rule.put("newField", newField);
        rule.put("valueType", valueType);
        rule.put("retain", true);
        return rule;
    }

    private JSONObject genCommonRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", method);
        rule.put("fieldA", param.getJSONObject(0).getString("content"));
        rule.put("fieldB", param.getJSONObject(1).getString("content"));
        rule.put("newField", newField);
        rule.put("valueType", valueType);
        rule.put("retain", true);
        return rule;
    }

    private JSONObject genAbsRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        String precision = ruleObj.getString("precision");
        String precisionType = ruleObj.getString("precisionType");
        JSONArray param = ruleObj.getJSONArray("param");
        JSONObject rule = new JSONObject();
        rule.put("calcType", method);
        rule.put("fieldA", param.getJSONObject(0).getString("content"));
        rule.put("newField", newField);
        rule.put("valueType", valueType);
        rule.put("precision", precision);
        rule.put("precisionType", precisionType);
        rule.put("retain", true);
        return rule;
    }
}
