package com.digiwin.athena.executionengine.service.facade.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.model.input.InputParamModuleBuilder;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.facade.data.IScraper;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/5/14
 */
@Service("metricDataset")
public class MetricDatasetScraper implements IScraper {
    @Autowired
    private IExecutionFacade executionFacade;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricScraper.class);

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty(metric.getGroupBy()) ? null : JSONArray.parseArray(JSONArray.toJSONString(metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty(metric.getFilter().getChildren()) ? null : JSONObject.parseObject(JSONObject.toJSONString(metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty(metric.getHaving().getChildren()) ? null : JSONObject.parseObject(JSONObject.toJSONString(metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty(metric.getSort()) ? null : JSONArray.parseArray(JSONObject.toJSONString(metric.getSort())));
        dataDescription.setDynamicSchema(dynamicSchema);
        dataDescription.setProductLineRows(context.getPermissions() == null || context.getPermissions().isEmpty() ? null : JSONArray.parseArray(JSONObject.toJSONString(context.getPermissions().get("rows"))));
        dataDescription.setProductLineInfo(context.getProductLineInfo());
        dataDescription.setDataset(true);
        InputParamModuleBuilder inputParamModuleBuilder = new InputParamModuleBuilder()
                .setActionId(metric.getMetric())
                .setEocMaps(context.getEocMaps())
                .setSysParam(context.getParam())
                .setTenantId(context.getTenantId())
                .setDataDescription(dataDescription)
                .setRoles(context.getRoles());
        InputParamModule inputParam = new InputParamModule(inputParamModuleBuilder);
        LOGGER.info(String.format(LogConstant.AGILE_DATA + "取指标数据入参:%s", "SolutionStepMetricAnalyzer.getMetricData", inputParam));
        return executionFacade.query(inputParam);
    }
}
