package com.digiwin.athena.executionengine.service.facade.mapping.param;

import com.digiwin.athena.executionengine.component.param.InputParam;
import com.digiwin.athena.executionengine.component.param.PullingParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * @description:
 * @author: fenglei
 * @date: 2020-11-20
 */
public class ConstructionUtils {

    ExecuteContext context;
    List<ParamBase> actionParams;

    private static final Logger LOGGER = LoggerFactory.getLogger(ParamMappingUtils.class);

    protected ConstructionUtils(ExecuteContext context, List<ParamBase> actionParams) {
        this.context = context;
        this.actionParams = actionParams;
    }

    /**
     * 用于生成含有集合的实例路径，需要传入当前实例的下标
     *
     * @param parentConcreteCollectionPath
     * @param parentParamBase
     * @param paramBase
     * @param arrayPos                     当前实例路径的对应的数据实例下标
     * @return
     */
    protected String getConcreteJsonPath(String parentConcreteCollectionPath,
                                         ParamBase parentParamBase, ParamBase paramBase, int arrayPos) {
        return getConcreteJsonPath(parentConcreteCollectionPath, parentParamBase, paramBase)
                + "[" + arrayPos + "]";
    }


    /**
     * 根据当前属性paramBase的映射关系中的value，和其上一层映射关系中的value，
     * 计算后在，依据上一层的具体jsonpath生成当前paramBase映射关系value对应的jsonpath
     *
     * @param parentConcreteCollectionPath
     * @param parentParamBase
     * @param paramBase
     * @return
     */
    protected String getConcreteJsonPath(String parentConcreteCollectionPath,
                                         ParamBase parentParamBase, ParamBase paramBase) {
        //eg: "A.B"
        String parentParamPath = parentParamBase.getValue();
        return getConcreteJsonPath(parentConcreteCollectionPath, parentParamPath, paramBase);
    }

    /**
     * 根据当前属性paramBase的映射关系中的value，和其上一层映射关系中的value，
     * 计算后在，依据上一层的具体jsonpath生成当前paramBase映射关系value对应的jsonpath
     *
     * @param parentConcreteCollectionPath
     * @param paramBase
     * @return
     */
    protected String getConcreteJsonPath(String parentConcreteCollectionPath,
                                         String parentParamPath, ParamBase paramBase) {
        //eg: "A.B.C.D"
        String paramPath = paramBase.getValue();

        //eg: ".C.D"
        String path = paramPath.replace(parentParamPath, "");
        return parentConcreteCollectionPath + path;
    }

    /**
     * 请参看concreteJsonPath定义处的注释描述
     *
     * @param paramElement
     * @return key: paramBase.value
     * value: paramBase
     */
    protected Map<String, ParamBase> getSrcParamBase(ParamElement paramElement) {
        Map<String, ParamBase> paramBaseCollection = new HashMap<>();

        ///这里paramElement.getParamPath()中是含有actionId的，需要把actionId去掉
        //String elementParamPath = StringUtils.replaceFirst(paramElement.getParamPath(), paramElement.getActionId() + ".", "");
        String elementParamPath = StringUtils.substringAfter(paramElement.getParamPath(), paramElement.getActionId() + ".");


        //遍历所有的属于当前action的映射关系
        for (ParamBase paramBase : actionParams) {
            if (paramBase.getName().equals(elementParamPath)) {
                paramBaseCollection.put(getMultipleSourceKey(paramBase), paramBase);
            }
        }
        return paramBaseCollection;
    }

    /**
     * 生成多来源的key
     *
     * @param paramBase
     * @return
     */
    public String getMultipleSourceKey(ParamBase paramBase) {
        String key = paramBase.getValue() + "@@";
        if (paramBase.getClass() == InputParam.class) {
            key += ((InputParam) paramBase).getParamType();
        } else if (paramBase.getClass() == PullingParam.class) {
            key += ((PullingParam) paramBase).getSource();
        }
        return key;
    }

    /**
     * 取当前数据源对应到的所有集合层次路径
     *
     * @param paramBase 数据源
     * @param actionId  action
     * @return
     */
    protected List<String> getPathInfo(ParamBase paramBase, String actionId) {
        return paramBase.getCollectionPath(context.getDataMappingManager(), actionId, paramBase.getValue());
    }

    /**
     * 获取多数据源下对应到的所有集合层次路径
     *
     * @param paramBaseList 数据映射
     * @param actionId      action
     * @return P1.paramBase.name  = P1
     * P1.paramBase.value = A.B.C.D.E.F
     * <p>
     * Map<key, List<String>> :
     * key: "A.B.C.D.E.F"
     * List<String> 层次的路径,A\C\E为集合属性
     * get(0): "A"
     * get(1): "A.B.C"
     * get(2): "A.B.C.D.E"
     */
    protected Map<String, List<String>> getPathInfo(Map<String, ParamBase> paramBaseList, String actionId) {
        Map<String, List<String>> pathInfo = new HashMap<>();
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            ParamBase paramBase = paramBaseEntry.getValue();
            List<String> pathInfoList = getPathInfo(paramBase, actionId);

            if (pathInfo.containsKey(paramBase.getValue())) {
                ////这里按道理不应该出现啊！每次getPathInfo拿到的是某一个映射的数据结构，
                //  因为调用处只会用同一个request参数取映射，只调用一次，所以不应该出现相同的映射结果
                LOGGER.error("getPathInfo执行错误，请检查代码的调用： paramBase.name:" + paramBase.getName());
            } else {
                pathInfo.put(getMultipleSourceKey(paramBase), pathInfoList);
            }
        }
        return pathInfo;
    }

    protected ParamBase getRealParentParamBase(ParamBase paramBase, Map<String, ParamBase> parentParamBaseList) {
        try {
            String actionId = paramBase.getSrcActionId(context);

            for (Map.Entry<String, ParamBase> parentParamBaseEntry : parentParamBaseList.entrySet()) {
                ParamBase parentParam = parentParamBaseEntry.getValue();
                //判断是相同的数据源
                if (!actionId.equals(parentParam.getSrcActionId(context))) {
                    continue;
                }

                //判断paramPath字符串存在派生的关系, parentParamPath一定从paramPath的0位置开始可以匹配到
                if (!paramBase.getValue().startsWith(parentParam.getValue())) {
                    continue;
                }

                //走到这可以认为已经匹配到了符合条件的parentParamBase
                return parentParam;
            }
        } catch (Exception e) {
            LOGGER.error("通过param映射关系分析ActionId失败: " + paramBase.getName(), e);
            return null;
        }

        return null;
    }

    /**
     * @param paramBase
     * @param actionId  当前执行参数映射的Action的ActionId
     * @param pos
     */
    protected void setParentJsonPath(ParamBase paramBase, String actionId, String srcParamBase, int pos) {
        paramBase.setParentPathPos(context.getDataMappingManager(), actionId, srcParamBase, pos);
    }

    /**
     * @param paramBase
     * @param actionId  当前执行参数映射的Action的ActionId
     * @param pos
     */
    protected void setJsonPath(ParamBase paramBase, String actionId, String srcParamBase, int pos) {
        paramBase.setPathPos(context.getDataMappingManager(), actionId, srcParamBase, pos);
    }

    /**
     * @param paramBase
     * @param ActionId  当前执行参数映射的Action的ActionId
     */
    protected String getJsonPath(ParamBase paramBase, String ActionId) {
        try {
            return paramBase.getDataJsonPath(context.getDataMappingManager(), ActionId, paramBase.getValue());
        }catch (Exception e){
            System.out.println("报错的actionId是：" + ActionId + "paramBase是：" + JsonUtil.getJsonString(paramBase));
        }
        return "";
    }

}
