package com.digiwin.athena.executionengine.service.facade.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.dto.schema.DateFormatDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/13
 */
@Service
public class GroupConvertor extends AbstractSchemaConvertor {
    /**
     * 聚合查询类型
     */
    private static final int AGGREGATION_QUERY_TYPE = 1;

    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        int dataType = querySchema.getIntValue("dataType");
        if (dynamicSchema == null) {
            if (AGGREGATION_QUERY_TYPE == dataType) {
                querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream().filter(o -> !"N".equals(((JSONObject) o).getString("isEnableAggregate")))
                        .forEach(o -> ((JSONObject) o).put("defaultValue", "auto"));
            }

            return;
        }
        JSONArray groups = null;
        if (dynamicSchema instanceof JSONArray) {
            groups = (JSONArray) dynamicSchema;
        } else if (dynamicSchema instanceof List) {
            groups = JSONArray.parseArray(JSONObject.toJSONString(schemaTransDto.getDynamicSchema()));
        }


        if (AGGREGATION_QUERY_TYPE != dataType) {
            doComputeList(querySchema, groups, schemaTransDto);
            return;
        }


        if (CollectionUtils.isEmpty(groups)) {
            querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream().filter(o -> !"N".equals(((JSONObject) o).getString("isEnableAggregate")))
                    .forEach(o -> ((JSONObject) o).put("defaultValue", "auto"));
            return;
        }
        Map<String, String> mapping = getReversalShowFieldMapping(querySchema);

        boolean fieldMatch = groups.stream().map(o -> (JSONObject) o)
                .filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_FIELD.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE)))
                .anyMatch(item -> mapping.containsKey(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT)));
        if (fieldMatch) {
            Map<String, String> map = groups.stream()
                    .map(o -> (JSONObject) o)
                    .map(item -> item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT))
                    .filter(item -> mapping.get(item) != null)
                    .collect(Collectors.toMap(item -> mapping.get(item), item -> item));
            querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream()
                    .filter(o -> !map.containsKey(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)))
                    .filter(o -> !"N".equals(((JSONObject) o).getString("isEnableAggregate")))
                    .forEach(o -> ((JSONObject) o).put("defaultValue", "auto"));
        }else{
            querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream().filter(o -> !"N".equals(((JSONObject) o).getString("isEnableAggregate")))
                    .forEach(o -> ((JSONObject) o).put("defaultValue", "auto"));
        }

        //calculate 只处理日期类型
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject) o)
                .filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE)))
                .collect(Collectors.toList());

        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }

        JSONObject computeObj = JSONObject.parseObject(JSONObject.toJSONString(schemaTransDto.getComputeObj()));

        List<DateFormatDto> dateFormatDtos = new ArrayList<>();
        calculateObj.forEach(item -> {
            String content = item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty(computeList)) {
                return;
            }

            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject) o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);

                    String field = fieldParam.getString("content");
                    String format = formatParam.getString("content");
                    dateFormatDtos.add(new DateFormatDto(field, format));
                }
            });
        });

        if (CollectionUtils.isEmpty(dateFormatDtos)) {
            return;
        }

        boolean calMatch = dateFormatDtos.stream().anyMatch(o -> mapping.containsKey(o.getField()));
        if (calMatch) {

            Map<String, DateFormatDto> map = dateFormatDtos.stream()
                    .filter(item -> mapping.get(item.getField()) != null)
                    .collect(Collectors.toMap(item -> mapping.get(item.getField()), item -> item));

            querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream()
                    .filter(o -> map.containsKey(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)))
                    .forEach(o -> ((JSONObject) o).fluentRemove("defaultValue").fluentPut("dateGranularity", map.get(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)).getFormat()));

            if (!fieldMatch) {
                querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream()
                        .filter(o -> !map.containsKey(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)))
                        .filter(o -> !"N".equals(((JSONObject) o).getString("isEnableAggregate")))
                        .forEach(o -> ((JSONObject) o).put("defaultValue", "auto"));
            }

        }

    }

    private void doComputeList(JSONObject querySchema, JSONArray groups, SchemaTransDto schemaTransDto) {
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject) o)
                .filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE)))
                .collect(Collectors.toList());

        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }

        JSONObject computeObj = JSONObject.parseObject(JSONObject.toJSONString(schemaTransDto.getComputeObj()));

        List<DateFormatDto> dateFormatDtos = new ArrayList<>();
        calculateObj.forEach(item -> {
            String content = item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty(computeList)) {
                return;
            }

            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject) o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);

                    String field = fieldParam.getString("content");
                    String format = formatParam.getString("content");
                    dateFormatDtos.add(new DateFormatDto(field, format));
                }
            });
        });

        if (CollectionUtils.isEmpty(dateFormatDtos)) {
            return;
        }

        Map<String, String> mapping = getReversalShowFieldMapping(querySchema);
        boolean calMatch = dateFormatDtos.stream().anyMatch(o -> mapping.containsKey(o.getField()));
        if (calMatch) {

            Map<String, DateFormatDto> map = dateFormatDtos.stream()
                    .filter(item -> mapping.get(item.getField()) != null)
                    .collect(Collectors.toMap(item -> mapping.get(item.getField()), item -> item));

            querySchema.getJSONArray(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS).stream()
                    .filter(o -> map.containsKey(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)))
                    .forEach(o -> ((JSONObject) o).fluentPut("dateGranularity", map.get(((JSONObject) o).getString(FieldNameConstant.DYNAMIC_SCHEMA_FIELD)).getFormat()));

        }
    }
}
